/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.util;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.Module;
import java.util.Properties;
import org.jclouds.util.ClassLoadingUtils;

public class Modules2 {
    public static Iterable<Module> modulesFromCommaDelimitedString(String moduleClasses) {
        Iterable<Module> modules = ImmutableSet.of();
        if (moduleClasses != null) {
            ImmutableList<String> transformer = ImmutableList.copyOf(Splitter.on(',').split(moduleClasses));
            modules = Iterables.transform(transformer, new Function<String, Module>(){

                @Override
                public Module apply(String from) {
                    try {
                        return (Module)ClassLoadingUtils.loadClass(Modules2.class, from).newInstance();
                    }
                    catch (InstantiationException e) {
                        throw new RuntimeException("error instantiating " + from, e);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException("error instantiating " + from, e);
                    }
                }
            });
        }
        return modules;
    }

    public static Iterable<Module> modulesForProviderInProperties(String providerName, Properties props) {
        return Iterables.concat(Modules2.modulesFromProperty(props, "jclouds.modules"), Modules2.modulesFromProperty(props, providerName + ".modules"));
    }

    public static Iterable<Module> modulesFromProperty(Properties props, String property) {
        return Modules2.modulesFromCommaDelimitedString(props.getProperty(property, null));
    }
}

