/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.util;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class Maps2 {
    public static <K> Function<Map<K, ?>, Set<K>> keySetFunction() {
        return new Function<Map<K, ?>, Set<K>>(){

            @Override
            public Set<K> apply(Map<K, ?> arg0) {
                return arg0.keySet();
            }

            public String toString() {
                return "keySet()";
            }
        };
    }

    public static <K, V> Map<K, V> convertUnsafe(Multimap<K, V> in) {
        LinkedHashMap<K, V> out = Maps.newLinkedHashMap();
        for (Map.Entry<K, V> entry : in.entries()) {
            out.put(entry.getKey(), entry.getValue());
        }
        return ImmutableMap.copyOf(out);
    }

    public static <V> Map<String, V> renameKey(Map<String, V> in, String k1, String k2) {
        if (Preconditions.checkNotNull(in, "input map").containsKey(Preconditions.checkNotNull(k1, "old key"))) {
            ImmutableMap.Builder<String, V> builder = ImmutableMap.builder();
            builder.putAll(Maps.filterKeys(in, Predicates.not(Predicates.equalTo(k1))));
            V tags = in.get(k1);
            builder.put(Preconditions.checkNotNull(k2, "new key"), tags);
            in = builder.build();
        }
        return in;
    }

    public static <K1, K2, V> Map<K2, V> transformKeys(Map<K1, V> in, Function<K1, K2> fn) {
        Preconditions.checkNotNull(in, "input map");
        Preconditions.checkNotNull(fn, "function");
        ImmutableMap.Builder<K2, V> returnVal = ImmutableMap.builder();
        for (Map.Entry<K1, V> entry : in.entrySet()) {
            returnVal.put(fn.apply(entry.getKey()), entry.getValue());
        }
        return returnVal.build();
    }

    public static <K, V> Supplier<Map<K, V>> composeMapSupplier(Iterable<Supplier<Map<K, V>>> suppliers) {
        return new ListMapSupplier<K, V>(suppliers);
    }

    public static <K, V> Map<K, V> fromKeys(Set<K> keys, Function<? super K, V> valueFunction) {
        HashMap<K, V> result = Maps.newHashMapWithExpectedSize(keys.size());
        for (K key : keys) {
            result.put(Preconditions.checkNotNull(key), valueFunction.apply(key));
        }
        return result;
    }

    public static <K, V> ImmutableMap<K, V> uniqueIndex(Iterable<? extends V> values, Function<? super V, ? extends K> keyFunction) {
        return ImmutableMap.copyOf(Maps.uniqueIndex(values, keyFunction));
    }

    static class ListMapSupplier<K, V>
    implements Supplier<Map<K, V>> {
        private final Iterable<Supplier<Map<K, V>>> suppliers;

        ListMapSupplier(Iterable<Supplier<Map<K, V>>> suppliers) {
            this.suppliers = Preconditions.checkNotNull(suppliers, "suppliers");
        }

        @Override
        public Map<K, V> get() {
            LinkedHashMap<K, V> toReturn = Maps.newLinkedHashMap();
            for (Supplier<Map<K, V>> supplier : this.suppliers) {
                toReturn.putAll(supplier.get());
            }
            return toReturn;
        }
    }
}

