/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.NoSuchElementException;
import javax.annotation.Resource;
import javax.inject.Inject;
import org.jclouds.cim.ResourceAllocationSettingData;
import org.jclouds.cim.functions.HardwareBuilderFromResourceAllocations;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.predicates.ImagePredicates;
import org.jclouds.domain.Location;
import org.jclouds.logging.Logger;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;
import org.jclouds.trmk.vcloud_0_8.domain.VApp;

public class HardwareForVCloudExpressVApp
implements Function<VApp, Hardware> {
    @Resource
    protected Logger logger = Logger.NULL;
    private final Function<ReferenceType, Location> findLocationForResource;
    private final HardwareBuilderFromResourceAllocations rasdToHardwareBuilder;

    @Inject
    protected HardwareForVCloudExpressVApp(Function<ReferenceType, Location> findLocationForResource, HardwareBuilderFromResourceAllocations rasdToHardwareBuilder) {
        this.findLocationForResource = Preconditions.checkNotNull(findLocationForResource, "findLocationForResource");
        this.rasdToHardwareBuilder = Preconditions.checkNotNull(rasdToHardwareBuilder, "rasdToHardwareBuilder");
    }

    @Override
    public Hardware apply(VApp from) {
        Preconditions.checkNotNull(from, "VApp");
        try {
            HardwareBuilder builder = this.rasdToHardwareBuilder.apply((Iterable<? extends ResourceAllocationSettingData>)from.getResourceAllocations());
            builder.location(this.findLocationForResource.apply(Preconditions.checkNotNull(from, "from").getVDC()));
            builder.ids(from.getHref().toASCIIString()).name(from.getName()).supportsImage(ImagePredicates.idEquals(from.getHref().toASCIIString()));
            builder.hypervisor("VMware");
            return builder.build();
        }
        catch (NoSuchElementException e) {
            this.logger.debug("incomplete data to form vApp %s", from.getHref());
            return null;
        }
    }
}

