/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.slicehost.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.domain.Location;
import org.jclouds.logging.Logger;
import org.jclouds.slicehost.domain.Slice;
import org.jclouds.util.Predicates2;

@Singleton
public class SliceToNodeMetadata
implements Function<Slice, NodeMetadata> {
    protected final Supplier<Location> location;
    protected final Map<Slice.Status, NodeMetadata.Status> sliceToNodeStatus;
    protected final Supplier<Set<? extends Image>> images;
    protected final Supplier<Set<? extends Hardware>> hardwares;
    protected final GroupNamingConvention nodeNamingConvention;
    @Resource
    protected Logger logger = Logger.NULL;

    @Inject
    SliceToNodeMetadata(Map<Slice.Status, NodeMetadata.Status> sliceStateToNodeStatus, @Memoized Supplier<Set<? extends Image>> images, Supplier<Location> location, @Memoized Supplier<Set<? extends Hardware>> hardwares, GroupNamingConvention.Factory namingConvention) {
        this.nodeNamingConvention = Preconditions.checkNotNull(namingConvention, "namingConvention").createWithoutPrefix();
        this.sliceToNodeStatus = Preconditions.checkNotNull(sliceStateToNodeStatus, "sliceStateToNodeStatus");
        this.images = Preconditions.checkNotNull(images, "images");
        this.location = Preconditions.checkNotNull(location, "location");
        this.hardwares = Preconditions.checkNotNull(hardwares, "hardwares");
    }

    @Override
    public NodeMetadata apply(Slice from) {
        NodeMetadataBuilder builder = new NodeMetadataBuilder();
        builder.ids(from.getId() + "");
        builder.name(from.getName());
        builder.hostname(from.getName());
        builder.location(this.location.get());
        builder.group(this.nodeNamingConvention.groupInUniqueNameOrNull(from.getName()));
        builder.imageId(from.getImageId() + "");
        builder.operatingSystem(this.parseOperatingSystem(from));
        builder.hardware(this.parseHardware(from));
        builder.status(this.sliceToNodeStatus.get((Object)from.getStatus()));
        builder.publicAddresses(Iterables.filter(from.getAddresses(), Predicates.not(Predicates2.startsWith("10."))));
        builder.privateAddresses(Iterables.filter(from.getAddresses(), Predicates2.startsWith("10.")));
        return builder.build();
    }

    protected Hardware parseHardware(Slice from) {
        try {
            return Iterables.find((Iterable)this.hardwares.get(), new FindHardwareForSlice(from));
        }
        catch (NoSuchElementException e) {
            this.logger.debug("could not find a matching hardware for slice %s", from);
            return null;
        }
    }

    protected OperatingSystem parseOperatingSystem(Slice from) {
        try {
            return Iterables.find((Iterable)this.images.get(), new FindImageForSlice(from)).getOperatingSystem();
        }
        catch (NoSuchElementException e) {
            this.logger.debug("could not find a matching image for slice %s in location %s", from, this.location);
            return null;
        }
    }

    private static class FindHardwareForSlice
    implements Predicate<Hardware> {
        private final Slice slice;

        private FindHardwareForSlice(Slice slice) {
            this.slice = slice;
        }

        @Override
        public boolean apply(Hardware input) {
            return input.getProviderId().equals(this.slice.getFlavorId() + "");
        }
    }

    private static class FindImageForSlice
    implements Predicate<Image> {
        private final Slice slice;

        private FindImageForSlice(Slice slice) {
            this.slice = slice;
        }

        @Override
        public boolean apply(Image input) {
            return input.getProviderId().equals(this.slice.getImageId() + "");
        }
    }
}

