/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.route53.xml;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.route53.domain.Zone;
import org.jclouds.route53.domain.ZoneAndNameServers;
import org.jclouds.route53.xml.ZoneHandler;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class GetHostedZoneResponseHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<ZoneAndNameServers> {
    private final ZoneHandler zoneHandler;
    private StringBuilder currentText = new StringBuilder();
    private boolean inZone;
    private Zone zone;
    private ImmutableList.Builder<String> nameServers = ImmutableList.builder();

    @Inject
    public GetHostedZoneResponseHandler(ZoneHandler zoneHandler) {
        this.zoneHandler = zoneHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ZoneAndNameServers getResult() {
        try {
            ZoneAndNameServers zoneAndNameServers = ZoneAndNameServers.create(this.zone, this.nameServers.build());
            return zoneAndNameServers;
        }
        finally {
            this.zone = null;
            this.nameServers = ImmutableList.builder();
        }
    }

    @Override
    public void startElement(String url, String name, String qName, Attributes attributes) {
        if (SaxUtils.equalsOrSuffix(qName, "HostedZone")) {
            this.inZone = true;
        }
        if (this.inZone) {
            this.zoneHandler.startElement(url, name, qName, attributes);
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (this.inZone) {
            if (qName.equals("HostedZone")) {
                this.inZone = false;
                this.zone = this.zoneHandler.getResult();
            } else {
                this.zoneHandler.endElement(uri, name, qName);
            }
        } else if (qName.equals("NameServer")) {
            this.nameServers.add((Object)SaxUtils.currentOrNull(this.currentText));
        }
        this.currentText = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.inZone) {
            this.zoneHandler.characters(ch, start, length);
        } else {
            this.currentText.append(ch, start, length);
        }
    }
}

