/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.route53.functions;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.internal.CallerArg0ToPagedIterable;
import org.jclouds.route53.Route53Api;
import org.jclouds.route53.domain.Zone;
import org.jclouds.route53.features.ZoneApi;

@Beta
public class ZonesToPagedIterable
extends CallerArg0ToPagedIterable<Zone, ZonesToPagedIterable> {
    private final Route53Api api;

    @Inject
    protected ZonesToPagedIterable(Route53Api api) {
        this.api = Preconditions.checkNotNull(api, "api");
    }

    @Override
    protected Function<Object, IterableWithMarker<Zone>> markerToNextForCallingArg0(String ignored) {
        final ZoneApi zoneApi = this.api.getZoneApi();
        return new Function<Object, IterableWithMarker<Zone>>(){

            @Override
            public IterableWithMarker<Zone> apply(Object input) {
                return zoneApi.listAt(input.toString());
            }

            public String toString() {
                return "listZones()";
            }
        };
    }
}

