/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.blobstore.functions;

import com.google.common.base.Function;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.openstack.swift.domain.MutableObjectInfoWithMetadata;
import org.jclouds.openstack.swift.domain.internal.MutableObjectInfoWithMetadataImpl;

@Singleton
public class ResourceToObjectInfo
implements Function<StorageMetadata, MutableObjectInfoWithMetadata> {
    @Override
    public MutableObjectInfoWithMetadata apply(StorageMetadata from) {
        if (from == null) {
            return null;
        }
        MutableObjectInfoWithMetadataImpl to = new MutableObjectInfoWithMetadataImpl();
        if (from.getType() == StorageType.BLOB) {
            to.setContentType(((BlobMetadata)from).getContentMetadata().getContentType());
            to.setBytes(((BlobMetadata)from).getContentMetadata().getContentLength());
            to.setHash(((BlobMetadata)from).getContentMetadata().getContentMD5());
        } else if (from.getType() == StorageType.RELATIVE_PATH) {
            to.setContentType("application/directory");
        }
        if (from.getETag() != null && to.getHash() == null) {
            to.setHash(CryptoStreams.hex(from.getETag()));
        }
        to.setName(from.getName());
        to.setLastModified(from.getLastModified());
        if (from.getUserMetadata() != null) {
            for (Map.Entry<String, String> entry : from.getUserMetadata().entrySet()) {
                to.getMetadata().put(entry.getKey().toLowerCase(), entry.getValue());
            }
        }
        return to;
    }
}

