/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.blobstore.functions;

import com.google.common.base.Function;
import javax.inject.Singleton;
import org.jclouds.http.options.GetOptions;

@Singleton
public class BlobToObjectGetOptions
implements Function<org.jclouds.blobstore.options.GetOptions, GetOptions> {
    @Override
    public GetOptions apply(org.jclouds.blobstore.options.GetOptions from) {
        GetOptions httpOptions = new GetOptions();
        if (from != null) {
            if (from.getIfMatch() != null) {
                httpOptions.ifETagMatches(from.getIfMatch());
            }
            if (from.getIfModifiedSince() != null) {
                httpOptions.ifModifiedSince(from.getIfModifiedSince());
            }
            if (from.getIfNoneMatch() != null) {
                httpOptions.ifETagDoesntMatch(from.getIfNoneMatch());
            }
            if (from.getIfUnmodifiedSince() != null) {
                httpOptions.ifUnmodifiedSince(from.getIfUnmodifiedSince());
            }
            for (String range : from.getRanges()) {
                String[] firstLast = range.split("\\-");
                if (firstLast.length == 2) {
                    httpOptions.range(Long.parseLong(firstLast[0]), Long.parseLong(firstLast[1]));
                    continue;
                }
                if (range.startsWith("-")) {
                    httpOptions.tail(Long.parseLong(firstLast[0]));
                    continue;
                }
                httpOptions.startAt(Long.parseLong(firstLast[0]));
            }
        }
        return httpOptions;
    }
}

