/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.domain;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import java.beans.ConstructorProperties;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.openstack.v2_0.domain.Resource;

public class ServerCreated
extends Resource {
    private final Optional<String> adminPass;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return ServerCreated.builder().fromServerCreated(this);
    }

    @ConstructorProperties(value={"id", "name", "links", "adminPass"})
    protected ServerCreated(String id, @Nullable String name, Set<Link> links, @Nullable String adminPass) {
        super(id, name, links);
        this.adminPass = Optional.fromNullable(adminPass);
    }

    public Optional<String> getAdminPass() {
        return this.adminPass;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.adminPass);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ServerCreated that = (ServerCreated)ServerCreated.class.cast(obj);
        return super.equals(that) && Objects.equal(this.adminPass, that.adminPass);
    }

    @Override
    protected Objects.ToStringHelper string() {
        return super.string().add("adminPass", this.adminPass.orNull());
    }

    public static final class Builder
    extends Resource.Builder<Builder> {
        protected String adminPass;

        public Builder adminPass(String adminPass) {
            this.adminPass = adminPass;
            return this.self();
        }

        @Override
        public ServerCreated build() {
            return new ServerCreated(this.id, this.name, this.links, this.adminPass);
        }

        public Builder fromServerCreated(ServerCreated in) {
            return ((Builder)super.fromResource(in)).adminPass(in.getAdminPass().orNull());
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

