/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.domain;

import com.google.common.base.Preconditions;

public enum IpProtocol {
    TCP,
    UDP,
    ICMP,
    UNRECOGNIZED;


    public String value() {
        return this.name().toLowerCase();
    }

    public String toString() {
        return this.value();
    }

    public static IpProtocol fromValue(String protocol) {
        try {
            return IpProtocol.valueOf(Preconditions.checkNotNull(protocol, "protocol").toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return UNRECOGNIZED;
        }
    }
}

