/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Set;
import org.jclouds.openstack.keystone.v2_0.domain.Endpoint;

public class Service
extends ForwardingSet<Endpoint> {
    private final String type;
    private final String name;
    private final Set<Endpoint> endpoints;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromService(this);
    }

    @ConstructorProperties(value={"type", "name", "endpoints"})
    protected Service(String type, String name, Set<Endpoint> endpoints) {
        this.type = Preconditions.checkNotNull(type, "type");
        this.name = Preconditions.checkNotNull(name, "name");
        this.endpoints = ImmutableSet.copyOf((Collection)Preconditions.checkNotNull(endpoints, "endpoints"));
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    @Deprecated
    public Set<Endpoint> getEndpoints() {
        return this.endpoints;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.type, this.name, this.endpoints);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Service that = (Service)Service.class.cast(obj);
        return Objects.equal(this.type, that.type) && Objects.equal(this.name, that.name) && Objects.equal(this.endpoints, that.endpoints);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper(this).omitNullValues().add("type", this.type).add("name", this.name).add("endpoints", this.endpoints);
    }

    @Override
    public String toString() {
        return this.string().toString();
    }

    @Override
    protected Set<Endpoint> delegate() {
        return this.endpoints;
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String type;
        protected String name;
        protected ImmutableSet.Builder<Endpoint> endpoints = ImmutableSet.builder();

        protected abstract T self();

        public T type(String type) {
            this.type = type;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T endpoint(Endpoint endpoint) {
            this.endpoints.add((Object)endpoint);
            return this.self();
        }

        public T endpoints(Iterable<Endpoint> endpoints) {
            this.endpoints.addAll((Iterable)endpoints);
            return this.self();
        }

        @Deprecated
        public T endpoints(Endpoint ... in) {
            return this.endpoints(ImmutableSet.copyOf(in));
        }

        public Service build() {
            return new Service(this.type, this.name, (Set<Endpoint>)((Object)this.endpoints.build()));
        }

        public T fromService(Service in) {
            return ((Builder)((Builder)this.type(in.getType())).name(in.getName())).endpoints(in);
        }
    }
}

