/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.net.domain;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Set;
import org.jclouds.net.domain.IpProtocol;

@Beta
public class IpPermission
implements Comparable<IpPermission> {
    private final int fromPort;
    private final int toPort;
    private final Multimap<String, String> tenantIdGroupNamePairs;
    private final Set<String> groupIds;
    private final IpProtocol ipProtocol;
    private final Set<String> cidrBlocks;

    public static Builder builder() {
        return new Builder();
    }

    protected IpPermission(IpProtocol ipProtocol, int fromPort, int toPort, Multimap<String, String> tenantIdGroupNamePairs, Iterable<String> groupIds, Iterable<String> cidrBlocks) {
        this.fromPort = fromPort;
        this.toPort = toPort;
        this.tenantIdGroupNamePairs = ImmutableMultimap.copyOf(Preconditions.checkNotNull(tenantIdGroupNamePairs, "tenantIdGroupNamePairs"));
        this.ipProtocol = Preconditions.checkNotNull(ipProtocol, "ipProtocol");
        this.groupIds = ImmutableSet.copyOf(Preconditions.checkNotNull(groupIds, "groupIds"));
        this.cidrBlocks = ImmutableSet.copyOf(Preconditions.checkNotNull(cidrBlocks, "cidrBlocks"));
    }

    @Override
    public int compareTo(IpPermission o) {
        return this == o ? 0 : this.getIpProtocol().compareTo(o.getIpProtocol());
    }

    public IpProtocol getIpProtocol() {
        return this.ipProtocol;
    }

    public int getFromPort() {
        return this.fromPort;
    }

    public int getToPort() {
        return this.toPort;
    }

    public Multimap<String, String> getTenantIdGroupNamePairs() {
        return this.tenantIdGroupNamePairs;
    }

    public Set<String> getGroupIds() {
        return this.groupIds;
    }

    public Set<String> getCidrBlocks() {
        return this.cidrBlocks;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof IpPermission)) {
            return false;
        }
        IpPermission that = (IpPermission)IpPermission.class.cast(o);
        return Objects.equal((Object)this.ipProtocol, (Object)that.ipProtocol) && Objects.equal(this.fromPort, that.fromPort) && Objects.equal(this.toPort, that.toPort) && Objects.equal(this.tenantIdGroupNamePairs, that.tenantIdGroupNamePairs) && Objects.equal(this.groupIds, that.groupIds) && Objects.equal(this.cidrBlocks, that.cidrBlocks);
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.ipProtocol, this.fromPort, this.toPort, this.tenantIdGroupNamePairs, this.groupIds, this.groupIds});
    }

    public String toString() {
        return this.string().toString();
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper("").add("ipProtocol", (Object)this.ipProtocol).add("fromPort", this.fromPort).add("toPort", this.toPort).add("tenantIdGroupNamePairs", this.tenantIdGroupNamePairs).add("groupIds", this.groupIds).add("groupIds", this.groupIds);
    }

    public static class Builder {
        private IpProtocol ipProtocol;
        private int fromPort;
        private int toPort;
        private Multimap<String, String> tenantIdGroupNamePairs = LinkedHashMultimap.create();
        private Set<String> groupIds = Sets.newLinkedHashSet();
        private Set<String> cidrBlocks = Sets.newLinkedHashSet();

        public Builder ipProtocol(IpProtocol ipProtocol) {
            this.ipProtocol = ipProtocol;
            return this;
        }

        public Builder fromPort(int fromPort) {
            this.fromPort = fromPort;
            return this;
        }

        public Builder toPort(int toPort) {
            this.toPort = toPort;
            return this;
        }

        public Builder tenantIdGroupNamePair(String tenantId, String groupName) {
            this.tenantIdGroupNamePairs.put(tenantId, groupName);
            return this;
        }

        public Builder tenantIdGroupNamePairs(Multimap<String, String> tenantIdGroupNamePairs) {
            this.tenantIdGroupNamePairs.putAll(tenantIdGroupNamePairs);
            return this;
        }

        public Builder cidrBlock(String cidrBlock) {
            this.cidrBlocks.add(cidrBlock);
            return this;
        }

        public Builder cidrBlocks(Iterable<String> cidrBlocks) {
            Iterables.addAll(this.cidrBlocks, cidrBlocks);
            return this;
        }

        public Builder groupId(String groupId) {
            this.groupIds.add(groupId);
            return this;
        }

        public Builder groupIds(Iterable<String> groupIds) {
            Iterables.addAll(this.groupIds, groupIds);
            return this;
        }

        public IpPermission build() {
            return new IpPermission(this.ipProtocol, this.fromPort, this.toPort, this.tenantIdGroupNamePairs, this.groupIds, this.cidrBlocks);
        }
    }
}

