/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.location.config;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Sets;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.domain.Location;
import org.jclouds.internal.ClassMethodArgsAndReturnVal;
import org.jclouds.location.Iso3166;
import org.jclouds.location.Provider;
import org.jclouds.location.Region;
import org.jclouds.location.Zone;
import org.jclouds.location.predicates.RegionIdFilter;
import org.jclouds.location.predicates.ZoneIdFilter;
import org.jclouds.location.suppliers.ImplicitLocationSupplier;
import org.jclouds.location.suppliers.ImplicitRegionIdSupplier;
import org.jclouds.location.suppliers.LocationIdToIso3166CodesSupplier;
import org.jclouds.location.suppliers.LocationsSupplier;
import org.jclouds.location.suppliers.ProviderURISupplier;
import org.jclouds.location.suppliers.RegionIdToURISupplier;
import org.jclouds.location.suppliers.RegionIdToZoneIdsSupplier;
import org.jclouds.location.suppliers.RegionIdsSupplier;
import org.jclouds.location.suppliers.ZoneIdToURISupplier;
import org.jclouds.location.suppliers.ZoneIdsSupplier;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.functions.ImplicitOptionalConverter;
import org.jclouds.rest.suppliers.MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier;
import org.jclouds.util.Suppliers2;

public class LocationModule
extends AbstractModule {
    @Override
    protected void configure() {
        this.bind(new TypeLiteral<Function<ClassMethodArgsAndReturnVal, Optional<Object>>>(){}).to(ImplicitOptionalConverter.class);
    }

    @Provides
    @Singleton
    @Iso3166
    protected Supplier<Map<String, Supplier<Set<String>>>> isoCodesSupplier(AtomicReference<AuthorizationException> authException, @Named(value="jclouds.session-interval") long seconds, LocationIdToIso3166CodesSupplier uncached) {
        return MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier.create(authException, uncached, seconds, TimeUnit.SECONDS);
    }

    @Provides
    @Singleton
    @Provider
    protected Supplier<URI> provideProvider(AtomicReference<AuthorizationException> authException, @Named(value="jclouds.session-interval") long seconds, ProviderURISupplier uncached) {
        return MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier.create(authException, uncached, seconds, TimeUnit.SECONDS);
    }

    @Provides
    @Singleton
    protected Supplier<Location> implicitLocationSupplier(AtomicReference<AuthorizationException> authException, @Named(value="jclouds.session-interval") long seconds, ImplicitLocationSupplier uncached) {
        return MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier.create(authException, uncached, seconds, TimeUnit.SECONDS);
    }

    @Provides
    @Singleton
    @Memoized
    protected Supplier<Set<? extends Location>> memoizedLocationsSupplier(AtomicReference<AuthorizationException> authException, @Named(value="jclouds.session-interval") long seconds, LocationsSupplier uncached) {
        return MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier.create(authException, uncached, seconds, TimeUnit.SECONDS);
    }

    @Provides
    @Singleton
    @Region
    protected Supplier<Set<String>> regionIdsSupplier(AtomicReference<AuthorizationException> authException, @Named(value="jclouds.session-interval") long seconds, RegionIdFilter filter, RegionIdsSupplier uncached) {
        return MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier.create(authException, Suppliers2.compose(new FilterStrings(filter), uncached), seconds, TimeUnit.SECONDS);
    }

    @Provides
    @Singleton
    @Zone
    protected Supplier<Set<String>> zoneIdsSupplier(AtomicReference<AuthorizationException> authException, @Named(value="jclouds.session-interval") long seconds, ZoneIdFilter filter, ZoneIdsSupplier uncached) {
        return MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier.create(authException, Suppliers2.compose(new FilterStrings(filter), uncached), seconds, TimeUnit.SECONDS);
    }

    @Provides
    @Singleton
    @Region
    protected Supplier<Map<String, Supplier<URI>>> regionIdToURISupplier(AtomicReference<AuthorizationException> authException, @Named(value="jclouds.session-interval") long seconds, RegionIdToURISupplier uncached) {
        return MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier.create(authException, uncached, seconds, TimeUnit.SECONDS);
    }

    @Provides
    @Singleton
    @Region
    protected Supplier<String> implicitRegionIdSupplier(AtomicReference<AuthorizationException> authException, @Named(value="jclouds.session-interval") long seconds, ImplicitRegionIdSupplier uncached) {
        return MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier.create(authException, uncached, seconds, TimeUnit.SECONDS);
    }

    @Provides
    @Singleton
    @Zone
    protected Supplier<Map<String, Supplier<Set<String>>>> regionIdToZoneIdsSupplier(AtomicReference<AuthorizationException> authException, @Named(value="jclouds.session-interval") long seconds, RegionIdToZoneIdsSupplier uncached) {
        return MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier.create(authException, uncached, seconds, TimeUnit.SECONDS);
    }

    @Provides
    @Singleton
    @Zone
    protected Supplier<Map<String, Supplier<URI>>> zoneIdToURISupplier(AtomicReference<AuthorizationException> authException, @Named(value="jclouds.session-interval") long seconds, ZoneIdToURISupplier uncached) {
        return MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier.create(authException, uncached, seconds, TimeUnit.SECONDS);
    }

    static class FilterStrings
    implements Function<Set<String>, Set<String>> {
        public final Predicate<String> filter;

        public FilterStrings(Predicate<String> filter) {
            this.filter = Preconditions.checkNotNull(filter, "filter");
        }

        @Override
        public Set<String> apply(Set<String> input) {
            return Sets.filter(input, this.filter);
        }

        public String toString() {
            return "filterStrings(" + this.filter + ")";
        }
    }
}

