/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.loadbalancer.internal;

import com.google.common.base.Preconditions;
import com.google.common.io.Closeables;
import com.google.common.reflect.TypeToken;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.Context;
import org.jclouds.internal.BaseView;
import org.jclouds.loadbalancer.LoadBalancerService;
import org.jclouds.loadbalancer.LoadBalancerServiceContext;
import org.jclouds.location.Provider;
import org.jclouds.rest.RestContext;
import org.jclouds.rest.Utils;

@Singleton
public class LoadBalancerServiceContextImpl
extends BaseView
implements LoadBalancerServiceContext {
    private final LoadBalancerService loadBalancerService;
    private final Utils utils;

    @Inject
    public LoadBalancerServiceContextImpl(@Provider Context backend, @Provider TypeToken<? extends Context> backendType, LoadBalancerService loadBalancerService, Utils utils) {
        super(backend, backendType);
        this.utils = utils;
        this.loadBalancerService = Preconditions.checkNotNull(loadBalancerService, "loadBalancerService");
    }

    @Override
    public LoadBalancerService getLoadBalancerService() {
        return this.loadBalancerService;
    }

    @Override
    public Utils getUtils() {
        return this.utils();
    }

    @Override
    public Utils utils() {
        return this.utils;
    }

    @Override
    public <S, A> RestContext<S, A> getProviderSpecificContext() {
        return (RestContext)this.delegate();
    }

    @Override
    public void close() {
        Closeables.closeQuietly(this.delegate());
    }

    @Override
    public int hashCode() {
        return this.delegate().hashCode();
    }

    @Override
    public String toString() {
        return this.delegate().toString();
    }

    @Override
    public boolean equals(Object obj) {
        return this.delegate().equals(obj);
    }
}

