/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.options;

import com.google.common.collect.ImmutableSet;
import org.jclouds.cloudstack.domain.AllocationState;
import org.jclouds.cloudstack.domain.Host;
import org.jclouds.cloudstack.options.AccountInDomainOptions;

public class ListHostsOptions
extends AccountInDomainOptions {
    public static final ListHostsOptions NONE = new ListHostsOptions();

    public ListHostsOptions id(String id) {
        this.queryParameters.replaceValues("id", ImmutableSet.of(id + ""));
        return this;
    }

    public ListHostsOptions allocationState(AllocationState allocationState) {
        this.queryParameters.replaceValues("allocationstate", ImmutableSet.of(allocationState.toString()));
        return this;
    }

    public ListHostsOptions clusterId(String clusterId) {
        this.queryParameters.replaceValues("clusterid", ImmutableSet.of(clusterId + ""));
        return this;
    }

    public ListHostsOptions keyword(String keyword) {
        this.queryParameters.replaceValues("keyword", ImmutableSet.of(keyword));
        return this;
    }

    public ListHostsOptions name(String name) {
        this.queryParameters.replaceValues("name", ImmutableSet.of(name));
        return this;
    }

    public ListHostsOptions page(long page) {
        this.queryParameters.replaceValues("page", ImmutableSet.of(page + ""));
        return this;
    }

    public ListHostsOptions pageSize(long pageSize) {
        this.queryParameters.replaceValues("pagesize", ImmutableSet.of(pageSize + ""));
        return this;
    }

    public ListHostsOptions podId(String podId) {
        this.queryParameters.replaceValues("podid", ImmutableSet.of(podId + ""));
        return this;
    }

    public ListHostsOptions state(String state) {
        this.queryParameters.replaceValues("state", ImmutableSet.of(state));
        return this;
    }

    public ListHostsOptions type(Host.Type type) {
        this.queryParameters.replaceValues("type", ImmutableSet.of(type.toString()));
        return this;
    }

    public ListHostsOptions virtualMachineId(String virtualMachineId) {
        this.queryParameters.replaceValues("virtualmachineid", ImmutableSet.of(virtualMachineId + ""));
        return this;
    }

    public ListHostsOptions zoneId(String zoneId) {
        this.queryParameters.replaceValues("zoneid", ImmutableSet.of(zoneId + ""));
        return this;
    }

    @Override
    public ListHostsOptions accountInDomain(String account, String domain) {
        return (ListHostsOptions)ListHostsOptions.class.cast(super.accountInDomain(account, domain));
    }

    @Override
    public ListHostsOptions domainId(String domainId) {
        return (ListHostsOptions)ListHostsOptions.class.cast(super.domainId(domainId));
    }

    public static class Builder {
        public static ListHostsOptions id(String id) {
            ListHostsOptions options = new ListHostsOptions();
            return options.id(id);
        }

        public static ListHostsOptions allocationState(AllocationState allocationState) {
            ListHostsOptions options = new ListHostsOptions();
            return options.allocationState(allocationState);
        }

        public static ListHostsOptions clusterId(String clusterId) {
            ListHostsOptions options = new ListHostsOptions();
            return options.clusterId(clusterId);
        }

        public static ListHostsOptions keyword(String keyword) {
            ListHostsOptions options = new ListHostsOptions();
            return options.keyword(keyword);
        }

        public static ListHostsOptions name(String name) {
            ListHostsOptions options = new ListHostsOptions();
            return options.name(name);
        }

        public static ListHostsOptions page(long page) {
            ListHostsOptions options = new ListHostsOptions();
            return options.page(page);
        }

        public static ListHostsOptions pageSize(long pageSize) {
            ListHostsOptions options = new ListHostsOptions();
            return options.pageSize(pageSize);
        }

        public static ListHostsOptions podId(String podId) {
            ListHostsOptions options = new ListHostsOptions();
            return options.podId(podId);
        }

        public static ListHostsOptions state(String state) {
            ListHostsOptions options = new ListHostsOptions();
            return options.state(state);
        }

        public static ListHostsOptions type(Host.Type type) {
            ListHostsOptions options = new ListHostsOptions();
            return options.type(type);
        }

        public static ListHostsOptions virtualMachineId(String virtualMachineId) {
            ListHostsOptions options = new ListHostsOptions();
            return options.virtualMachineId(virtualMachineId);
        }

        public static ListHostsOptions zoneId(String zoneId) {
            ListHostsOptions options = new ListHostsOptions();
            return options.zoneId(zoneId);
        }

        public static ListHostsOptions accountInDomain(String account, String domain) {
            ListHostsOptions options = new ListHostsOptions();
            return options.accountInDomain(account, domain);
        }

        public static ListHostsOptions domainId(String domainId) {
            ListHostsOptions options = new ListHostsOptions();
            return options.domainId(domainId);
        }
    }
}

