/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.util.concurrent.ListenableFuture;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.QueryParam;
import org.jclouds.cloudstack.domain.Account;
import org.jclouds.cloudstack.domain.AsyncCreateResponse;
import org.jclouds.cloudstack.features.AccountAsyncClient;
import org.jclouds.cloudstack.filters.AuthenticationFilter;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.Unwrap;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;

@RequestFilters(value={AuthenticationFilter.class})
@QueryParams(keys={"response"}, values={"json"})
public interface DomainAccountAsyncClient
extends AccountAsyncClient {
    @GET
    @QueryParams(keys={"command"}, values={"enableAccount"})
    @SelectJson(value={"account"})
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<Account> enableAccount(@QueryParam(value="account") String var1, @QueryParam(value="domainid") String var2);

    @GET
    @QueryParams(keys={"command"}, values={"disableAccount"})
    @Unwrap
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<AsyncCreateResponse> disableAccount(@QueryParam(value="account") String var1, @QueryParam(value="domainid") String var2, @QueryParam(value="lock") boolean var3);
}

