/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma.functions;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import java.util.Map;
import javax.annotation.Resource;
import javax.inject.Singleton;
import org.jclouds.cloudsigma.domain.StaticIPInfo;
import org.jclouds.logging.Logger;

@Singleton
public class MapToStaticIPInfo
implements Function<Map<String, String>, StaticIPInfo> {
    @Resource
    protected Logger logger = Logger.NULL;

    @Override
    public StaticIPInfo apply(Map<String, String> from) {
        if (from.size() == 0) {
            return null;
        }
        if (from.size() == 0) {
            return null;
        }
        StaticIPInfo.Builder builder = new StaticIPInfo.Builder();
        builder.ip(from.get("resource"));
        builder.user(from.get("user"));
        builder.netmask(from.get("netmask"));
        builder.nameservers(Splitter.on(' ').split(from.get("nameserver")));
        builder.gateway(from.get("gateway"));
        try {
            return builder.build();
        }
        catch (NullPointerException e) {
            this.logger.trace("entry missing data: %s; %s", e.getMessage(), from);
            return null;
        }
    }
}

