/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import java.net.URI;
import java.util.Properties;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.apis.internal.BaseApiMetadata;
import org.jclouds.atmos.AtmosAsyncClient;
import org.jclouds.atmos.AtmosClient;
import org.jclouds.atmos.blobstore.config.AtmosBlobStoreContextModule;
import org.jclouds.atmos.config.AtmosRestClientModule;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.rest.RestContext;
import org.jclouds.rest.internal.BaseRestApiMetadata;

public class AtmosApiMetadata
extends BaseRestApiMetadata {
    private static final long serialVersionUID = 8067252472547486854L;
    public static final TypeToken<RestContext<AtmosClient, AtmosAsyncClient>> CONTEXT_TOKEN = new TypeToken<RestContext<AtmosClient, AtmosAsyncClient>>(){
        private static final long serialVersionUID = -5070937833892503232L;
    };

    private static Builder builder() {
        return new Builder();
    }

    @Override
    public Builder toBuilder() {
        return AtmosApiMetadata.builder().fromApiMetadata(this);
    }

    public AtmosApiMetadata() {
        this(AtmosApiMetadata.builder());
    }

    protected AtmosApiMetadata(Builder builder) {
        super(builder);
    }

    public static Properties defaultProperties() {
        Properties properties = BaseRestApiMetadata.defaultProperties();
        properties.setProperty("jclouds.regions", "DEFAULT");
        properties.setProperty("jclouds.blobstore.metaprefix", "X-Object-Meta-");
        return properties;
    }

    public static class Builder
    extends BaseRestApiMetadata.Builder {
        protected Builder() {
            super(AtmosClient.class, AtmosAsyncClient.class);
            ((BaseApiMetadata.Builder)this.id("atmos").name("EMC's Atmos API").identityName("Subtenant ID (UID)").credentialName("Shared Secret").documentation(URI.create("https://community.emc.com/docs/DOC-10508")).version("1.4.0").defaultEndpoint("https://accesspoint.atmosonline.com").defaultProperties(AtmosApiMetadata.defaultProperties()).view(TypeToken.of(BlobStoreContext.class))).defaultModules(ImmutableSet.of(AtmosRestClientModule.class, AtmosBlobStoreContextModule.class));
        }

        @Override
        public AtmosApiMetadata build() {
            return new AtmosApiMetadata(this);
        }

        @Override
        public Builder fromApiMetadata(ApiMetadata in) {
            super.fromApiMetadata(in);
            return this;
        }
    }
}

