/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.domain.network;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.vcloud.domain.network.nat.NatPolicy;
import org.jclouds.vcloud.domain.network.nat.NatRule;
import org.jclouds.vcloud.domain.network.nat.NatType;

public class NatService {
    private final boolean enabled;
    @Nullable
    private final NatType type;
    @Nullable
    private final NatPolicy policy;
    private final List<NatRule> natRules = Lists.newArrayList();

    public NatService(boolean enabled, @Nullable NatType type, @Nullable NatPolicy policy, Iterable<NatRule> natRules) {
        this.enabled = enabled;
        this.type = type;
        this.policy = policy;
        Iterables.addAll(this.natRules, Preconditions.checkNotNull(natRules, "natRules"));
    }

    public List<NatRule> getNatRules() {
        return this.natRules;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Nullable
    public NatType getType() {
        return this.type;
    }

    @Nullable
    public NatPolicy getPolicy() {
        return this.policy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NatService that = (NatService)NatService.class.cast(o);
        return Objects.equal(this.enabled, that.enabled) && Objects.equal((Object)this.type, (Object)that.type) && Objects.equal((Object)this.policy, (Object)that.policy) && Objects.equal(this.natRules, that.natRules);
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.enabled, this.type, this.policy, this.natRules});
    }

    public String toString() {
        Objects.ToStringHelper helper = Objects.toStringHelper("").omitNullValues().add("enabled", this.enabled).add("type", (Object)this.type).add("policy", (Object)this.policy);
        if (this.natRules.size() > 0) {
            helper.add("natRules", this.natRules);
        }
        return helper.toString();
    }
}

