/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.config;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Injector;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import java.net.URI;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.cim.xml.ResourceAllocationSettingDataHandler;
import org.jclouds.domain.Location;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.location.suppliers.ImplicitLocationSupplier;
import org.jclouds.location.suppliers.LocationsSupplier;
import org.jclouds.ovf.Envelope;
import org.jclouds.predicates.RetryablePredicate;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.annotations.ApiVersion;
import org.jclouds.rest.config.BinderUtils;
import org.jclouds.rest.config.RestClientModule;
import org.jclouds.rest.suppliers.MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier;
import org.jclouds.util.Maps2;
import org.jclouds.util.Suppliers2;
import org.jclouds.vcloud.VCloudAsyncClient;
import org.jclouds.vcloud.VCloudClient;
import org.jclouds.vcloud.VCloudToken;
import org.jclouds.vcloud.VCloudVersionsAsyncClient;
import org.jclouds.vcloud.VCloudVersionsClient;
import org.jclouds.vcloud.compute.functions.FindLocationForResource;
import org.jclouds.vcloud.compute.functions.ValidateVAppTemplateAndReturnEnvelopeOrThrowIllegalArgumentException;
import org.jclouds.vcloud.config.DefaultVCloudReferencesModule;
import org.jclouds.vcloud.domain.Catalog;
import org.jclouds.vcloud.domain.CatalogItem;
import org.jclouds.vcloud.domain.Org;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.VAppTemplate;
import org.jclouds.vcloud.domain.VCloudSession;
import org.jclouds.vcloud.domain.network.FenceMode;
import org.jclouds.vcloud.endpoints.Network;
import org.jclouds.vcloud.endpoints.OrgList;
import org.jclouds.vcloud.endpoints.VCloudLogin;
import org.jclouds.vcloud.endpoints.VDC;
import org.jclouds.vcloud.features.CatalogAsyncClient;
import org.jclouds.vcloud.features.CatalogClient;
import org.jclouds.vcloud.features.NetworkAsyncClient;
import org.jclouds.vcloud.features.NetworkClient;
import org.jclouds.vcloud.features.OrgAsyncClient;
import org.jclouds.vcloud.features.OrgClient;
import org.jclouds.vcloud.features.TaskAsyncClient;
import org.jclouds.vcloud.features.TaskClient;
import org.jclouds.vcloud.features.VAppAsyncClient;
import org.jclouds.vcloud.features.VAppClient;
import org.jclouds.vcloud.features.VAppTemplateAsyncClient;
import org.jclouds.vcloud.features.VAppTemplateClient;
import org.jclouds.vcloud.features.VDCAsyncClient;
import org.jclouds.vcloud.features.VDCClient;
import org.jclouds.vcloud.features.VmAsyncClient;
import org.jclouds.vcloud.features.VmClient;
import org.jclouds.vcloud.functions.CatalogItemsInCatalog;
import org.jclouds.vcloud.functions.CatalogItemsInOrg;
import org.jclouds.vcloud.functions.CatalogsInOrg;
import org.jclouds.vcloud.functions.DefaultNetworkNameInTemplate;
import org.jclouds.vcloud.functions.OrgsForLocations;
import org.jclouds.vcloud.functions.OrgsForNames;
import org.jclouds.vcloud.functions.VAppTemplatesForCatalogItems;
import org.jclouds.vcloud.functions.VDCsInOrg;
import org.jclouds.vcloud.handlers.ParseVCloudErrorFromHttpResponse;
import org.jclouds.vcloud.internal.VCloudLoginAsyncClient;
import org.jclouds.vcloud.internal.VCloudLoginClient;
import org.jclouds.vcloud.loaders.OVFLoader;
import org.jclouds.vcloud.loaders.VAppTemplateLoader;
import org.jclouds.vcloud.location.DefaultVDC;
import org.jclouds.vcloud.location.OrgAndVDCToLocationSupplier;
import org.jclouds.vcloud.predicates.TaskSuccess;
import org.jclouds.vcloud.xml.ovf.VCloudResourceAllocationSettingDataHandler;

@ConfiguresRestClient
public class VCloudRestClientModule
extends RestClientModule<VCloudClient, VCloudAsyncClient> {
    public static final Map<Class<?>, Class<?>> DELEGATE_MAP = ImmutableMap.builder().put(VAppTemplateClient.class, VAppTemplateAsyncClient.class).put(VAppClient.class, VAppAsyncClient.class).put(VmClient.class, VmAsyncClient.class).put(CatalogClient.class, CatalogAsyncClient.class).put(TaskClient.class, TaskAsyncClient.class).put(VDCClient.class, VDCAsyncClient.class).put(NetworkClient.class, NetworkAsyncClient.class).put(OrgClient.class, OrgAsyncClient.class).build();
    static final Function<ReferenceType, String> name = new Function<ReferenceType, String>(){

        @Override
        public String apply(ReferenceType from) {
            return from.getName();
        }
    };

    public VCloudRestClientModule() {
        super(DELEGATE_MAP);
    }

    @Provides
    @Singleton
    protected Supplier<VCloudSession> provideVCloudTokenCache(@Named(value="jclouds.session-interval") long seconds, AtomicReference<AuthorizationException> authException, final VCloudLoginClient login) {
        return MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier.create(authException, new Supplier<VCloudSession>(){

            @Override
            public VCloudSession get() {
                return login.login();
            }

            public String toString() {
                return Objects.toStringHelper(login).add("method", "login").toString();
            }
        }, seconds, TimeUnit.SECONDS);
    }

    @Override
    protected void configure() {
        super.configure();
        this.bind(new TypeLiteral<Function<Iterable<CatalogItem>, Iterable<VAppTemplate>>>(){}).to((TypeLiteral<Function<Iterable<CatalogItem>, Iterable<VAppTemplate>>>)new TypeLiteral<VAppTemplatesForCatalogItems>(){});
        this.bind(ResourceAllocationSettingDataHandler.class).to(VCloudResourceAllocationSettingDataHandler.class);
        this.installDefaultVCloudEndpointsModule();
        this.bind(new TypeLiteral<Function<ReferenceType, Location>>(){}).to((TypeLiteral<Function<ReferenceType, Location>>)new TypeLiteral<FindLocationForResource>(){});
        this.bind(new TypeLiteral<Function<Org, Iterable<Catalog>>>(){}).to((TypeLiteral<Function<Org, Iterable<Catalog>>>)new TypeLiteral<CatalogsInOrg>(){});
        this.bind(new TypeLiteral<Function<Org, Iterable<org.jclouds.vcloud.domain.VDC>>>(){}).to((TypeLiteral<Function<Org, Iterable<org.jclouds.vcloud.domain.VDC>>>)new TypeLiteral<VDCsInOrg>(){});
        this.bind(new TypeLiteral<Function<Iterable<String>, Iterable<Org>>>(){}).to((TypeLiteral<Function<Iterable<String>, Iterable<Org>>>)new TypeLiteral<OrgsForNames>(){});
        this.bind(new TypeLiteral<Function<Iterable<Location>, Iterable<Org>>>(){}).to((TypeLiteral<Function<Iterable<Location>, Iterable<Org>>>)new TypeLiteral<OrgsForLocations>(){});
        this.bind(new TypeLiteral<Function<Catalog, Iterable<CatalogItem>>>(){}).to((TypeLiteral<Function<Catalog, Iterable<CatalogItem>>>)new TypeLiteral<CatalogItemsInCatalog>(){});
        this.bind(new TypeLiteral<Function<Org, Iterable<CatalogItem>>>(){}).to((TypeLiteral<Function<Org, Iterable<CatalogItem>>>)new TypeLiteral<CatalogItemsInOrg>(){});
        this.bindCacheLoaders();
        this.bind(new TypeLiteral<Function<VAppTemplate, String>>(){}).annotatedWith(Network.class).to((TypeLiteral<Function<VAppTemplate, String>>)new TypeLiteral<DefaultNetworkNameInTemplate>(){});
        this.bind(new TypeLiteral<Function<VAppTemplate, Envelope>>(){}).to((TypeLiteral<Function<VAppTemplate, Envelope>>)new TypeLiteral<ValidateVAppTemplateAndReturnEnvelopeOrThrowIllegalArgumentException>(){});
        BinderUtils.bindClientAndAsyncClient(this.binder(), VCloudVersionsClient.class, VCloudVersionsAsyncClient.class);
        BinderUtils.bindClientAndAsyncClient(this.binder(), VCloudLoginClient.class, VCloudLoginAsyncClient.class);
    }

    protected void bindCacheLoaders() {
        this.bind(new TypeLiteral<CacheLoader<URI, VAppTemplate>>(){}).to((TypeLiteral<CacheLoader<URI, VAppTemplate>>)new TypeLiteral<VAppTemplateLoader>(){});
        this.bind(new TypeLiteral<CacheLoader<URI, Envelope>>(){}).to((TypeLiteral<CacheLoader<URI, Envelope>>)new TypeLiteral<OVFLoader>(){});
    }

    @Provides
    @Singleton
    @VDC
    protected Supplier<Map<String, String>> provideVDCtoORG(Supplier<Map<String, Org>> orgNameToOrgSupplier) {
        return Suppliers2.compose(new Function<Map<String, Org>, Map<String, String>>(){

            @Override
            public Map<String, String> apply(Map<String, Org> arg0) {
                ImmutableMap.Builder<String, String> returnVal = ImmutableMap.builder();
                for (Map.Entry<String, Org> orgr : arg0.entrySet()) {
                    for (String vdc : orgr.getValue().getVDCs().keySet()) {
                        returnVal.put(vdc, orgr.getKey());
                    }
                }
                return returnVal.build();
            }
        }, orgNameToOrgSupplier);
    }

    @Provides
    @Singleton
    protected Supplier<Map<String, Org>> provideOrgMapCache(@Named(value="jclouds.session-interval") long seconds, AtomicReference<AuthorizationException> authException, OrgMapSupplier supplier) {
        return MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier.create(authException, supplier, seconds, TimeUnit.SECONDS);
    }

    @Provides
    @Singleton
    @OrgList
    protected Supplier<URI> provideOrgListURI(Supplier<VCloudSession> sessionSupplier) {
        return Suppliers2.compose(new Function<VCloudSession, URI>(){

            @Override
            public URI apply(VCloudSession arg0) {
                return URI.create(Iterables.getLast(arg0.getOrgs().values()).getHref().toASCIIString().replaceAll("org/.*", "org"));
            }

            public String toString() {
                return "orgListURI()";
            }
        }, sessionSupplier);
    }

    protected void installDefaultVCloudEndpointsModule() {
        this.install(new DefaultVCloudReferencesModule());
    }

    @VCloudToken
    @Provides
    @Singleton
    Supplier<String> provideVCloudToken(Supplier<VCloudSession> cache) {
        return Suppliers2.compose(new Function<VCloudSession, String>(){

            @Override
            public String apply(VCloudSession input) {
                return Preconditions.checkNotNull(input.getVCloudToken(), "No token present in session");
            }
        }, cache);
    }

    @Provides
    @org.jclouds.vcloud.endpoints.Org
    @Singleton
    protected Supplier<Map<String, ReferenceType>> provideVDCtoORG(@Named(value="jclouds.session-interval") long seconds, AtomicReference<AuthorizationException> authException, OrgNameToOrgSupplier supplier) {
        return MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier.create(authException, supplier, seconds, TimeUnit.SECONDS);
    }

    @Provides
    @Singleton
    protected Supplier<Map<URI, org.jclouds.vcloud.domain.VDC>> provideURIToVDC(@Named(value="jclouds.session-interval") long seconds, AtomicReference<AuthorizationException> authException, URItoVDC supplier) {
        return MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier.create(authException, supplier, seconds, TimeUnit.SECONDS);
    }

    @Provides
    @Singleton
    @VCloudLogin
    protected Supplier<URI> provideAuthenticationURI(final VCloudVersionsClient versionService, final @ApiVersion String version) {
        return new Supplier<URI>(){

            @Override
            public URI get() {
                SortedMap<String, URI> versions = versionService.getSupportedVersions();
                Preconditions.checkState(versions.size() > 0, "No versions present");
                Preconditions.checkState(versions.containsKey(version), "version " + version + " not present in: " + versions);
                return (URI)versions.get(version);
            }

            public String toString() {
                return "login()";
            }
        };
    }

    @Provides
    @Singleton
    protected Supplier<Org> provideOrg(final Supplier<Map<String, Org>> orgSupplier, @org.jclouds.vcloud.endpoints.Org Supplier<ReferenceType> defaultOrg) {
        return Suppliers2.compose(new Function<ReferenceType, Org>(){

            @Override
            public Org apply(ReferenceType input) {
                return (Org)((Map)orgSupplier.get()).get(input.getName());
            }
        }, defaultOrg);
    }

    @Provides
    @Singleton
    protected Predicate<URI> successTester(Injector injector, @Named(value="jclouds.vcloud.timeout.task-complete") long completed) {
        return new RetryablePredicate<URI>(injector.getInstance(TaskSuccess.class), completed);
    }

    @Provides
    @Singleton
    protected Supplier<Map<String, Map<String, Catalog>>> provideOrgCatalogItemMapSupplierCache(@Named(value="jclouds.session-interval") long seconds, AtomicReference<AuthorizationException> authException, OrgCatalogSupplier supplier) {
        return MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier.create(authException, supplier, seconds, TimeUnit.SECONDS);
    }

    @Provides
    @Singleton
    protected Supplier<Map<String, Map<String, org.jclouds.vcloud.domain.VDC>>> provideOrgVDCSupplierCache(@Named(value="jclouds.session-interval") long seconds, AtomicReference<AuthorizationException> authException, OrgVDCSupplier supplier) {
        return MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier.create(authException, supplier, seconds, TimeUnit.SECONDS);
    }

    @Provides
    @Singleton
    protected Supplier<Map<String, Map<String, Map<String, CatalogItem>>>> provideOrgCatalogItemSupplierCache(@Named(value="jclouds.session-interval") long seconds, AtomicReference<AuthorizationException> authException, OrgCatalogItemSupplier supplier) {
        return MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier.create(authException, supplier, seconds, TimeUnit.SECONDS);
    }

    @Provides
    @Singleton
    protected FenceMode defaultFenceMode(@Named(value="jclouds.vcloud.defaults.fencemode") String fenceMode) {
        return FenceMode.fromValue(fenceMode);
    }

    @Provides
    @Singleton
    protected LoadingCache<URI, VAppTemplate> vAppTemplates(CacheLoader<URI, VAppTemplate> vAppTemplates) {
        return CacheBuilder.newBuilder().build(vAppTemplates);
    }

    @Provides
    @Singleton
    protected LoadingCache<URI, Envelope> envelopes(CacheLoader<URI, Envelope> envelopes) {
        return CacheBuilder.newBuilder().build(envelopes);
    }

    @Override
    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(ParseVCloudErrorFromHttpResponse.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(ParseVCloudErrorFromHttpResponse.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(ParseVCloudErrorFromHttpResponse.class);
    }

    @Override
    protected void installLocations() {
        super.installLocations();
        this.bind(ImplicitLocationSupplier.class).to(DefaultVDC.class).in(Scopes.SINGLETON);
        this.bind(LocationsSupplier.class).to(OrgAndVDCToLocationSupplier.class).in(Scopes.SINGLETON);
    }

    @Singleton
    public static class OrgCatalogItemSupplier
    implements Supplier<Map<String, Map<String, Map<String, CatalogItem>>>> {
        protected final Supplier<Map<String, Map<String, Catalog>>> catalogSupplier;
        protected final Function<Catalog, Iterable<CatalogItem>> allCatalogItemsInCatalog;

        @Inject
        protected OrgCatalogItemSupplier(Supplier<Map<String, Map<String, Catalog>>> catalogSupplier, Function<Catalog, Iterable<CatalogItem>> allCatalogItemsInCatalog) {
            this.catalogSupplier = catalogSupplier;
            this.allCatalogItemsInCatalog = allCatalogItemsInCatalog;
        }

        @Override
        public Map<String, Map<String, Map<String, CatalogItem>>> get() {
            return Maps.transformValues(this.catalogSupplier.get(), new Function<Map<String, Catalog>, Map<String, Map<String, CatalogItem>>>(){

                @Override
                public Map<String, Map<String, CatalogItem>> apply(Map<String, Catalog> from) {
                    return Maps.transformValues(from, new Function<Catalog, Map<String, CatalogItem>>(){

                        @Override
                        public Map<String, CatalogItem> apply(Catalog from) {
                            return Maps2.uniqueIndex(Iterables.filter(OrgCatalogItemSupplier.this.allCatalogItemsInCatalog.apply(from), Predicates.notNull()), name);
                        }
                    });
                }
            });
        }
    }

    @Singleton
    public static class OrgVDCSupplier
    implements Supplier<Map<String, Map<String, org.jclouds.vcloud.domain.VDC>>> {
        protected final Supplier<Map<String, Org>> orgSupplier;
        private final Function<Org, Iterable<org.jclouds.vcloud.domain.VDC>> allVDCsInOrg;

        @Inject
        protected OrgVDCSupplier(Supplier<Map<String, Org>> orgSupplier, Function<Org, Iterable<org.jclouds.vcloud.domain.VDC>> allVDCsInOrg) {
            this.orgSupplier = orgSupplier;
            this.allVDCsInOrg = allVDCsInOrg;
        }

        @Override
        public Map<String, Map<String, org.jclouds.vcloud.domain.VDC>> get() {
            return Maps.transformValues(Maps.transformValues(this.orgSupplier.get(), this.allVDCsInOrg), new Function<Iterable<? extends org.jclouds.vcloud.domain.VDC>, Map<String, org.jclouds.vcloud.domain.VDC>>(){

                @Override
                public Map<String, org.jclouds.vcloud.domain.VDC> apply(Iterable<? extends org.jclouds.vcloud.domain.VDC> from) {
                    return Maps2.uniqueIndex(Lists.newArrayList(from), name);
                }
            });
        }
    }

    @Singleton
    private static class OrgNameToOrgSupplier
    implements Supplier<Map<String, ReferenceType>> {
        private final Supplier<VCloudSession> sessionSupplier;

        @Inject
        OrgNameToOrgSupplier(Supplier<VCloudSession> sessionSupplier) {
            this.sessionSupplier = sessionSupplier;
        }

        @Override
        public Map<String, ReferenceType> get() {
            return this.sessionSupplier.get().getOrgs();
        }
    }

    @Singleton
    public static class URItoVDC
    implements Supplier<Map<URI, org.jclouds.vcloud.domain.VDC>> {
        private final Supplier<Map<String, Map<String, org.jclouds.vcloud.domain.VDC>>> orgVDCMap;

        @Inject
        URItoVDC(Supplier<Map<String, Map<String, org.jclouds.vcloud.domain.VDC>>> orgVDCMap) {
            this.orgVDCMap = orgVDCMap;
        }

        @Override
        public Map<URI, org.jclouds.vcloud.domain.VDC> get() {
            return Maps2.uniqueIndex(Iterables.concat(Iterables.transform(this.orgVDCMap.get().values(), new Function<Map<String, org.jclouds.vcloud.domain.VDC>, Iterable<org.jclouds.vcloud.domain.VDC>>(){

                @Override
                public Iterable<org.jclouds.vcloud.domain.VDC> apply(Map<String, org.jclouds.vcloud.domain.VDC> from) {
                    return from.values();
                }
            })), new Function<org.jclouds.vcloud.domain.VDC, URI>(){

                @Override
                public URI apply(org.jclouds.vcloud.domain.VDC from) {
                    return from.getHref();
                }
            });
        }
    }

    @Singleton
    public static class OrgCatalogSupplier
    implements Supplier<Map<String, Map<String, Catalog>>> {
        protected final Supplier<Map<String, Org>> orgSupplier;
        protected final Function<Org, Iterable<Catalog>> allCatalogsInOrg;

        @Inject
        protected OrgCatalogSupplier(Supplier<Map<String, Org>> orgSupplier, Function<Org, Iterable<Catalog>> allCatalogsInOrg) {
            this.orgSupplier = orgSupplier;
            this.allCatalogsInOrg = allCatalogsInOrg;
        }

        @Override
        public Map<String, Map<String, Catalog>> get() {
            return Maps.transformValues(Maps.transformValues(this.orgSupplier.get(), this.allCatalogsInOrg), new Function<Iterable<? extends Catalog>, Map<String, Catalog>>(){

                @Override
                public Map<String, Catalog> apply(Iterable<? extends Catalog> from) {
                    return Maps2.uniqueIndex(from, name);
                }
            });
        }
    }

    @Singleton
    public static class OrgMapSupplier
    implements Supplier<Map<String, Org>> {
        protected final Supplier<VCloudSession> sessionSupplier;
        protected final Function<Iterable<String>, Iterable<Org>> organizationsForNames;

        @Inject
        protected OrgMapSupplier(Supplier<VCloudSession> sessionSupplier, Function<Iterable<String>, Iterable<Org>> organizationsForNames) {
            this.sessionSupplier = sessionSupplier;
            this.organizationsForNames = organizationsForNames;
        }

        @Override
        public Map<String, Org> get() {
            return Maps2.uniqueIndex(this.organizationsForNames.apply(this.sessionSupplier.get().getOrgs().keySet()), name);
        }
    }
}

