/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.xml;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.NoSuchElementException;
import javax.annotation.Resource;
import javax.inject.Inject;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.logging.Logger;
import org.jclouds.trmk.vcloud_0_8.domain.KeyPair;
import org.jclouds.trmk.vcloud_0_8.xml.KeyPairsHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class KeyPairByNameHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<KeyPair> {
    @Resource
    protected Logger logger = Logger.NULL;
    private final KeyPairsHandler handler;

    @Inject
    public KeyPairByNameHandler(KeyPairsHandler handler) {
        this.handler = handler;
    }

    @Override
    public KeyPair getResult() {
        final String name = this.getRequest().getArgs().get(1).toString();
        try {
            return Iterables.find(this.handler.getResult(), new Predicate<KeyPair>(){

                @Override
                public boolean apply(KeyPair input) {
                    return input.getName().equals(name);
                }
            });
        }
        catch (NoSuchElementException e) {
            this.logger.debug("keypair %s/%s not found in %s", this.getRequest().getArgs().get(0), name, this.handler.getResult());
            return null;
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.handler.startElement(uri, localName, qName, attributes);
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        this.handler.endElement(uri, name, qName);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.handler.characters(ch, start, length);
    }
}

