/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.domain;

import com.google.common.base.Preconditions;

public enum TaskStatus {
    SUCCESS,
    RUNNING,
    QUEUED,
    ERROR,
    CANCELLED,
    UNRECOGNIZED;


    public String value() {
        return this.name().toLowerCase();
    }

    public String toString() {
        return this.value();
    }

    public static TaskStatus fromValue(String status) {
        if ("CANCELED".equals(status.toUpperCase())) {
            status = "CANCELLED";
        } else if ("FAILED".equals(status.toUpperCase())) {
            status = "ERROR";
        } else if ("COMPLETED".equals(status.toUpperCase())) {
            status = "SUCCESS";
        }
        try {
            return TaskStatus.valueOf(Preconditions.checkNotNull(status, "status").toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return UNRECOGNIZED;
        }
    }
}

