/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.ecloud.xml;

import java.util.Map;
import org.jclouds.trmk.ecloud.domain.ECloudOrg;
import org.jclouds.trmk.ecloud.domain.internal.ECloudOrgImpl;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;
import org.jclouds.trmk.vcloud_0_8.util.Utils;
import org.jclouds.trmk.vcloud_0_8.xml.OrgHandler;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ECloudOrgHandler
extends OrgHandler {
    private ReferenceType dataCentersList;
    private ReferenceType deviceTags;
    private ReferenceType vAppCatalog;

    @Override
    public ECloudOrg getResult() {
        return new ECloudOrgImpl(this.org.getName(), this.org.getType(), this.org.getHref(), this.description, this.catalogs, this.vdcs, this.tasksLists, this.keys, this.dataCentersList, this.deviceTags, this.vAppCatalog);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        Map<String, String> attributes = SaxUtils.cleanseAttributes(attrs);
        super.startElement(uri, localName, qName, attrs);
        if (qName.equals("Link") && attributes.containsKey("type")) {
            String type = attributes.get("type");
            if (type != null && type.endsWith("dataCentersList+xml")) {
                this.dataCentersList = Utils.newReferenceType(attributes);
            } else if (type != null && type.endsWith("tagsList+xml")) {
                this.deviceTags = Utils.newReferenceType(attributes);
            } else if (type != null && type.endsWith("VAppCatalogList+xml")) {
                this.vAppCatalog = Utils.newReferenceType(attributes);
            }
        }
    }
}

