/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Map;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.ShellToken;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.util.Utils;

public class Call
implements Statement {
    public static final Map<OsFamily, String> OS_TO_CALL = ImmutableMap.of(OsFamily.UNIX, "{function}{args} || return 1\n", OsFamily.WINDOWS, "call :{function}{args}\r\nif errorlevel 1 goto abort\r\n");
    private String function;
    private String[] args;

    public Call(String function, String ... args) {
        this.function = Preconditions.checkNotNull(function, "function");
        this.args = Preconditions.checkNotNull(args, "args");
    }

    @Override
    public String render(OsFamily family) {
        StringBuilder args = new StringBuilder();
        for (String arg : this.args) {
            args.append(" ").append(Utils.replaceTokens(arg, ShellToken.tokenValueMap(family)));
        }
        StringBuilder call = new StringBuilder();
        call.append(Utils.replaceTokens(OS_TO_CALL.get((Object)family), ImmutableMap.of("function", this.function, "args", args.toString())));
        return call.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.args);
        result = 31 * result + (this.function == null ? 0 : this.function.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Call other = (Call)obj;
        if (!Arrays.equals(this.args, other.args)) {
            return false;
        }
        return !(this.function == null ? other.function != null : !this.function.equals(other.function));
    }

    @Override
    public Iterable<String> functionDependencies(OsFamily family) {
        return ImmutableList.of(this.function);
    }
}

