/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.route53.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import org.jclouds.route53.domain.Change;
import org.jclouds.route53.domain.Zone;
import org.jclouds.route53.domain.ZoneAndNameServers;

public final class NewZone {
    private final ZoneAndNameServers zone;
    private final Change change;

    private NewZone(ZoneAndNameServers zone, Change change) {
        this.zone = Preconditions.checkNotNull(zone, "zone");
        this.change = Preconditions.checkNotNull(change, "change of %s", zone);
    }

    public Zone getZone() {
        return this.zone.getZone();
    }

    public ImmutableList<String> getNameServers() {
        return this.zone.getNameServers();
    }

    public Change getChange() {
        return this.change;
    }

    public int hashCode() {
        return Objects.hashCode(this.zone);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NewZone that = (NewZone)NewZone.class.cast(obj);
        return Objects.equal(this.zone, that.zone);
    }

    public String toString() {
        return Objects.toStringHelper("").add("zone", this.zone.getZone()).add("nameServers", this.zone.getNameServers()).add("change", this.change).toString();
    }

    public static NewZone create(ZoneAndNameServers zone, Change change) {
        return new NewZone(zone, change);
    }
}

