/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.route53.config;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import com.google.inject.Provides;
import java.util.Date;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.aws.config.AWSRestClientModule;
import org.jclouds.date.DateService;
import org.jclouds.date.TimeStamp;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.RequestSigner;
import org.jclouds.route53.Route53Api;
import org.jclouds.route53.Route53AsyncApi;
import org.jclouds.route53.features.RecordSetApi;
import org.jclouds.route53.features.RecordSetAsyncApi;
import org.jclouds.route53.features.ZoneApi;
import org.jclouds.route53.features.ZoneAsyncApi;
import org.jclouds.route53.filters.RestAuthentication;
import org.jclouds.route53.handlers.Route53ErrorHandler;

@ConfiguresRestClient
public class Route53RestClientModule
extends AWSRestClientModule<Route53Api, Route53AsyncApi> {
    public static final Map<Class<?>, Class<?>> DELEGATE_MAP = ImmutableMap.builder().put(ZoneApi.class, ZoneAsyncApi.class).put(RecordSetApi.class, RecordSetAsyncApi.class).build();

    public Route53RestClientModule() {
        super(TypeToken.of(Route53Api.class), TypeToken.of(Route53AsyncApi.class), DELEGATE_MAP);
    }

    @Provides
    @TimeStamp
    protected String provideTimeStamp(DateService dateService) {
        return dateService.rfc1123DateFormat(new Date(System.currentTimeMillis()));
    }

    @Provides
    @Singleton
    RequestSigner provideRequestSigner(RestAuthentication in) {
        return in;
    }

    @Override
    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(Route53ErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(Route53ErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(Route53ErrorHandler.class);
    }
}

