/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import javax.inject.Inject;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.predicates.NodePredicates;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.ZoneAndName;

public class AllNodesInGroupTerminated
implements Predicate<ZoneAndName> {
    private final ComputeService computeService;

    @Inject
    public AllNodesInGroupTerminated(ComputeService computeService) {
        this.computeService = Preconditions.checkNotNull(computeService, "computeService");
    }

    @Override
    public boolean apply(ZoneAndName input) {
        return Iterables.all(this.computeService.listNodesDetailsMatching(Predicates.or(NodePredicates.locationId(input.getZone()), NodePredicates.parentLocationId(input.getZone()))), Predicates.and(NodePredicates.inGroup(input.getName()), NodePredicates.TERMINATED));
    }
}

