/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.domain;

import com.google.common.base.Functions;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import org.jclouds.javax.annotation.Nullable;

public abstract class Resource {
    private final int id;
    private final List<Map<String, String>> links;
    private final ConcurrentSkipListMap<LinkType, URI> orderedSelfReferences;

    protected Resource(int id, List<Map<String, String>> links, @Nullable Map<LinkType, URI> orderedSelfReferences) {
        this.id = id;
        this.links = links == null ? ImmutableList.of() : ImmutableList.copyOf((Collection)Preconditions.checkNotNull(links, "links"));
        this.orderedSelfReferences = orderedSelfReferences == null ? new ConcurrentSkipListMap() : new ConcurrentSkipListMap<LinkType, URI>(orderedSelfReferences);
    }

    public int getId() {
        return this.id;
    }

    public List<Map<String, String>> getLinks() {
        return this.links;
    }

    public Map<LinkType, URI> getOrderedSelfReferences() {
        return this.orderedSelfReferences;
    }

    private void populateOrderedSelfReferences() {
        for (Map<String, String> linkProperties : this.links) {
            for (LinkType type : LinkType.values()) {
                if (!type.linkPredicate.apply(linkProperties)) continue;
                try {
                    this.orderedSelfReferences.put(type, new URI(linkProperties.get("href")));
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.orderedSelfReferences.isEmpty()) {
            throw new IllegalStateException("URI is not available");
        }
    }

    public URI getURI() {
        if (this.orderedSelfReferences.isEmpty()) {
            this.populateOrderedSelfReferences();
        }
        return this.orderedSelfReferences.firstEntry().getValue();
    }

    public URI getSelfURI() {
        if (this.orderedSelfReferences.isEmpty()) {
            this.populateOrderedSelfReferences();
        }
        return this.orderedSelfReferences.get((Object)LinkType.SELF);
    }

    public int hashCode() {
        return Objects.hashCode(this.id, this.orderedSelfReferences);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Resource that = (Resource)Resource.class.cast(obj);
        return Objects.equal(this.id, that.id) && Objects.equal(this.orderedSelfReferences, that.orderedSelfReferences);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper(this).add("id", this.id).add("links", this.links).add("orderedSelfReferences", this.orderedSelfReferences);
    }

    public String toString() {
        return this.string().toString();
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected int id;
        protected List<Map<String, String>> links = ImmutableList.of();
        protected Map<LinkType, URI> orderedSelfReferences;

        protected abstract T self();

        public T id(int id) {
            this.id = id;
            return this.self();
        }

        public T links(List<Map<String, String>> links) {
            this.links = ImmutableList.copyOf((Collection)Preconditions.checkNotNull(links, "links"));
            return this.self();
        }

        public T links(Map<String, String> ... in) {
            return this.links(ImmutableList.copyOf(in));
        }

        public T orderedSelfReferences(Map<LinkType, URI> orderedSelfReferences) {
            this.orderedSelfReferences = ImmutableMap.copyOf(orderedSelfReferences);
            return this.self();
        }

        public T fromResource(Resource in) {
            return ((Builder)this.links(in.getLinks())).orderedSelfReferences(in.getOrderedSelfReferences());
        }
    }

    public static enum LinkType {
        BOOKMARK_JSON(new Predicate<Map<String, String>>(){

            @Override
            public boolean apply(@Nullable Map<String, String> linkMap) {
                return Functions.forMap(linkMap, "").apply("rel").equals("bookmark") && Functions.forMap(linkMap, "").apply("type").contains("json");
            }
        }),
        BOOKMARK_ANY(new Predicate<Map<String, String>>(){

            @Override
            public boolean apply(@Nullable Map<String, String> linkMap) {
                return Functions.forMap(linkMap, "").apply("rel").equals("bookmark");
            }
        }),
        SELF(new Predicate<Map<String, String>>(){

            @Override
            public boolean apply(@Nullable Map<String, String> linkMap) {
                return Functions.forMap(linkMap, "").apply("rel").equals("self");
            }
        });

        Predicate<Map<String, String>> linkPredicate;

        private LinkType(Predicate<Map<String, String>> linkPredicate) {
            this.linkPredicate = linkPredicate;
        }
    }
}

