/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v1_1.handlers;

import com.google.common.cache.LoadingCache;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import javax.annotation.Resource;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpRetryHandler;
import org.jclouds.http.HttpUtils;
import org.jclouds.logging.Logger;
import org.jclouds.openstack.keystone.v1_1.domain.Auth;

@Singleton
public class RetryOnRenew
implements HttpRetryHandler {
    @Resource
    protected Logger logger = Logger.NULL;
    private final LoadingCache<Credentials, Auth> authenticationResponseCache;

    @Inject
    protected RetryOnRenew(LoadingCache<Credentials, Auth> authenticationResponseCache) {
        this.authenticationResponseCache = authenticationResponseCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shouldRetryRequest(HttpCommand command, HttpResponse response) {
        boolean retry = false;
        try {
            switch (response.getStatusCode()) {
                case 401: {
                    Multimap<String, String> headers = command.getCurrentRequest().getHeaders();
                    if (headers != null && headers.containsKey("X-Auth-User") && headers.containsKey("X-Auth-Key") && !headers.containsKey("X-Auth-Token")) {
                        retry = false;
                        break;
                    }
                    byte[] content = HttpUtils.closeClientButKeepContentStream(response);
                    if (content != null && new String(content).contains("lease renew")) {
                        this.logger.debug("invalidating authentication token", new Object[0]);
                        this.authenticationResponseCache.invalidateAll();
                        retry = true;
                        break;
                    }
                    retry = false;
                }
            }
            boolean bl = retry;
            return bl;
        }
        finally {
            HttpUtils.releasePayload(response);
        }
    }
}

