/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.location.suppliers.derived;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.location.Zone;
import org.jclouds.location.suppliers.ZoneIdsSupplier;

@Singleton
public class ZoneIdsFromRegionIdToZoneIdsValues
implements ZoneIdsSupplier {
    private final Supplier<Map<String, Supplier<Set<String>>>> regionIdToZoneIdsSupplier;

    @Inject
    protected ZoneIdsFromRegionIdToZoneIdsValues(@Zone Supplier<Map<String, Supplier<Set<String>>>> regionIdToZoneIdsSupplier) {
        this.regionIdToZoneIdsSupplier = regionIdToZoneIdsSupplier;
    }

    @Override
    public Set<String> get() {
        Collection<Supplier<Set<String>>> zones = this.regionIdToZoneIdsSupplier.get().values();
        return ImmutableSet.copyOf(Iterables.concat(Iterables.transform(zones, Suppliers.supplierFunction())));
    }
}

