/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.hpcloud.objectstorage.options;

import com.google.common.base.Preconditions;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class ListCDNContainerOptions
extends BaseHttpRequestOptions {
    public static final ListCDNContainerOptions NONE = new ListCDNContainerOptions();

    public ListCDNContainerOptions enabledOnly() {
        this.queryParameters.put("enabled_only", "true");
        return this;
    }

    public ListCDNContainerOptions afterMarker(String marker) {
        this.queryParameters.put("marker", Preconditions.checkNotNull(marker, "marker"));
        return this;
    }

    public ListCDNContainerOptions maxResults(int limit) {
        Preconditions.checkState(limit >= 0, "limit must be >= 0");
        Preconditions.checkState(limit <= 10000, "limit must be <= 10000");
        this.queryParameters.put("limit", Integer.toString(limit));
        return this;
    }

    public static class Builder {
        public static ListCDNContainerOptions enabledOnly() {
            ListCDNContainerOptions options = new ListCDNContainerOptions();
            return options.enabledOnly();
        }

        public static ListCDNContainerOptions afterMarker(String marker) {
            ListCDNContainerOptions options = new ListCDNContainerOptions();
            return options.afterMarker(marker);
        }

        public static ListCDNContainerOptions maxResults(int limit) {
            ListCDNContainerOptions options = new ListCDNContainerOptions();
            return options.maxResults(limit);
        }
    }
}

