/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Set;

public class Permission {
    private final Set<String> groups = Sets.newHashSet();
    private final Set<String> userIds = Sets.newHashSet();

    public Permission(Iterable<String> userIds, Iterable<String> groups) {
        Iterables.addAll(this.userIds, Preconditions.checkNotNull(userIds, "userIds"));
        Iterables.addAll(this.groups, Preconditions.checkNotNull(groups, "groups"));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.groups == null ? 0 : ((Object)this.groups).hashCode());
        result = 31 * result + (this.userIds == null ? 0 : ((Object)this.userIds).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Permission other = (Permission)obj;
        if (this.groups == null ? other.groups != null : !((Object)this.groups).equals(other.groups)) {
            return false;
        }
        return !(this.userIds == null ? other.userIds != null : !((Object)this.userIds).equals(other.userIds));
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public Set<String> getUserIds() {
        return this.userIds;
    }

    public String toString() {
        return "LaunchPermission [groups=" + this.groups + ", userIds=" + this.userIds + "]";
    }
}

