/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.deltacloud;

import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.ListenableFuture;
import java.net.URI;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import org.jclouds.deltacloud.collections.HardwareProfiles;
import org.jclouds.deltacloud.collections.Images;
import org.jclouds.deltacloud.collections.InstanceStates;
import org.jclouds.deltacloud.collections.Instances;
import org.jclouds.deltacloud.collections.Realms;
import org.jclouds.deltacloud.domain.DeltacloudCollection;
import org.jclouds.deltacloud.domain.HardwareProfile;
import org.jclouds.deltacloud.domain.Image;
import org.jclouds.deltacloud.domain.Instance;
import org.jclouds.deltacloud.domain.Realm;
import org.jclouds.deltacloud.domain.Transition;
import org.jclouds.deltacloud.functions.ReturnVoidOnRedirectedDelete;
import org.jclouds.deltacloud.options.CreateInstanceOptions;
import org.jclouds.deltacloud.xml.DeltacloudCollectionsHandler;
import org.jclouds.deltacloud.xml.HardwareProfileHandler;
import org.jclouds.deltacloud.xml.HardwareProfilesHandler;
import org.jclouds.deltacloud.xml.ImageHandler;
import org.jclouds.deltacloud.xml.ImagesHandler;
import org.jclouds.deltacloud.xml.InstanceHandler;
import org.jclouds.deltacloud.xml.InstanceStatesHandler;
import org.jclouds.deltacloud.xml.InstancesHandler;
import org.jclouds.deltacloud.xml.RealmHandler;
import org.jclouds.deltacloud.xml.RealmsHandler;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.filters.BasicAuthentication;
import org.jclouds.rest.annotations.Endpoint;
import org.jclouds.rest.annotations.EndpointParam;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.XMLResponseParser;
import org.jclouds.rest.functions.ReturnEmptyMultimapOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;

@RequestFilters(value={BasicAuthentication.class})
@Consumes(value={"application/xml"})
public interface DeltacloudAsyncClient {
    @GET
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    @XMLResponseParser(value=DeltacloudCollectionsHandler.class)
    public ListenableFuture<Set<DeltacloudCollection>> getCollections();

    @GET
    @Endpoint(value=InstanceStates.class)
    @ExceptionParser(value=ReturnEmptyMultimapOnNotFoundOr404.class)
    @XMLResponseParser(value=InstanceStatesHandler.class)
    public ListenableFuture<Multimap<Instance.State, Transition>> getInstanceStates();

    @GET
    @Endpoint(value=Realms.class)
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    @XMLResponseParser(value=RealmsHandler.class)
    public ListenableFuture<Set<Realm>> listRealms();

    @GET
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    @XMLResponseParser(value=RealmHandler.class)
    public ListenableFuture<Realm> getRealm(@EndpointParam URI var1);

    @GET
    @Endpoint(value=Images.class)
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    @XMLResponseParser(value=ImagesHandler.class)
    public ListenableFuture<Set<Image>> listImages();

    @GET
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    @XMLResponseParser(value=ImageHandler.class)
    public ListenableFuture<Image> getImage(@EndpointParam URI var1);

    @GET
    @Endpoint(value=HardwareProfiles.class)
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    @XMLResponseParser(value=HardwareProfilesHandler.class)
    public ListenableFuture<Set<HardwareProfile>> listHardwareProfiles();

    @GET
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    @XMLResponseParser(value=HardwareProfileHandler.class)
    public ListenableFuture<HardwareProfile> getHardwareProfile(@EndpointParam URI var1);

    @GET
    @Endpoint(value=Instances.class)
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    @XMLResponseParser(value=InstancesHandler.class)
    public ListenableFuture<Set<Instance>> listInstances();

    @GET
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    @XMLResponseParser(value=InstanceHandler.class)
    public ListenableFuture<Instance> getInstance(@EndpointParam URI var1);

    @POST
    @Endpoint(value=Instances.class)
    @XMLResponseParser(value=InstanceHandler.class)
    public ListenableFuture<Instance> createInstance(@FormParam(value="image_id") String var1, CreateInstanceOptions ... var2);

    @ExceptionParser(value=ReturnVoidOnRedirectedDelete.class)
    public ListenableFuture<Void> performAction(HttpRequest var1);
}

