/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.concurrent.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.concurrent.DynamicExecutors;
import org.jclouds.concurrent.MoreExecutors;
import org.jclouds.concurrent.SingleThreaded;
import org.jclouds.concurrent.config.ConfiguresExecutorService;
import org.jclouds.concurrent.config.DescribingExecutorService;
import org.jclouds.lifecycle.Closer;
import org.jclouds.logging.Logger;

@ConfiguresExecutorService
public class ExecutorServiceModule
extends AbstractModule {
    @VisibleForTesting
    final ExecutorService userExecutorFromConstructor;
    @VisibleForTesting
    final ExecutorService ioExecutorFromConstructor;

    @Inject
    public ExecutorServiceModule(@Named(value="jclouds.user-threads") ExecutorService userThreads, @Named(value="jclouds.io-worker-threads") ExecutorService ioThreads) {
        this.userExecutorFromConstructor = this.addToStringOnSubmit(this.checkNotGuavaSameThreadExecutor(userThreads));
        this.ioExecutorFromConstructor = this.addToStringOnSubmit(this.checkNotGuavaSameThreadExecutor(ioThreads));
    }

    ExecutorService addToStringOnSubmit(ExecutorService executor) {
        if (executor != null) {
            return new DescribingExecutorService(executor);
        }
        return executor;
    }

    ExecutorService checkNotGuavaSameThreadExecutor(ExecutorService executor) {
        if (executor != null && !executor.getClass().isAnnotationPresent(SingleThreaded.class) && executor.getClass().getSimpleName().indexOf("SameThread") != -1) {
            Logger.CONSOLE.warn("please switch from %s to %s or annotate your same threaded executor with @SingleThreaded", executor.getClass().getName(), MoreExecutors.SameThreadExecutorService.class.getName());
            return MoreExecutors.sameThreadExecutor();
        }
        return executor;
    }

    public ExecutorServiceModule() {
        this(null, null);
    }

    @Override
    protected void configure() {
    }

    @Provides
    @Singleton
    @Named(value="jclouds.user-threads")
    ExecutorService provideExecutorService(@Named(value="jclouds.user-threads") int count, Closer closer) {
        if (this.userExecutorFromConstructor != null) {
            return this.userExecutorFromConstructor;
        }
        return ExecutorServiceModule.shutdownOnClose(this.addToStringOnSubmit(this.newThreadPoolNamed("user thread %d", count)), closer);
    }

    @Provides
    @Singleton
    @Named(value="jclouds.io-worker-threads")
    ExecutorService provideIOExecutor(@Named(value="jclouds.io-worker-threads") int count, Closer closer) {
        if (this.ioExecutorFromConstructor != null) {
            return this.ioExecutorFromConstructor;
        }
        return ExecutorServiceModule.shutdownOnClose(this.addToStringOnSubmit(this.newThreadPoolNamed("i/o thread %d", count)), closer);
    }

    @VisibleForTesting
    static <T extends ExecutorService> T shutdownOnClose(T service, Closer closer) {
        closer.addToClose(new ShutdownExecutorOnClose(service));
        return service;
    }

    @VisibleForTesting
    ExecutorService newCachedThreadPoolNamed(String name) {
        return Executors.newCachedThreadPool(this.namedThreadFactory(name));
    }

    @VisibleForTesting
    ExecutorService newThreadPoolNamed(String name, int maxCount) {
        return maxCount == 0 ? this.newCachedThreadPoolNamed(name) : this.newScalingThreadPoolNamed(name, maxCount);
    }

    @VisibleForTesting
    ExecutorService newScalingThreadPoolNamed(String name, int maxCount) {
        return DynamicExecutors.newScalingThreadPool(1, maxCount, 60000L, this.namedThreadFactory(name));
    }

    protected ThreadFactory namedThreadFactory(String name) {
        return new ThreadFactoryBuilder().setNameFormat(name).setThreadFactory(Executors.defaultThreadFactory()).build();
    }

    static StackTraceElement[] getStackTraceHere() {
        StackTraceElement[] fullSubmissionTrace = Thread.currentThread().getStackTrace();
        StackTraceElement[] cleanedSubmissionTrace = new StackTraceElement[fullSubmissionTrace.length - 2];
        System.arraycopy(fullSubmissionTrace, 2, cleanedSubmissionTrace, 0, cleanedSubmissionTrace.length);
        return cleanedSubmissionTrace;
    }

    @VisibleForTesting
    static final class ShutdownExecutorOnClose
    implements Closeable {
        @Resource
        protected Logger logger = Logger.NULL;
        private final ExecutorService service;

        private ShutdownExecutorOnClose(ExecutorService service) {
            this.service = service;
        }

        @Override
        public void close() throws IOException {
            List<Runnable> runnables = this.service.shutdownNow();
            if (runnables.size() > 0) {
                this.logger.warn("when shutting down executor %s, runnables outstanding: %s", this.service, runnables);
            }
        }
    }
}

