/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.ComputeType;
import org.jclouds.compute.domain.internal.ComputeMetadataImpl;
import org.jclouds.domain.Location;
import org.jclouds.domain.ResourceMetadataBuilder;

public class ComputeMetadataBuilder
extends ResourceMetadataBuilder<ComputeType> {
    protected String id;
    protected ComputeType type;
    protected Set<String> tags = ImmutableSet.of();

    public ComputeMetadataBuilder(ComputeType type) {
        this.type = Preconditions.checkNotNull(type, "type");
    }

    public ComputeMetadataBuilder id(String id) {
        this.id = id;
        return this;
    }

    public ComputeMetadataBuilder tags(Iterable<String> tags) {
        this.tags = ImmutableSet.copyOf(Preconditions.checkNotNull(tags, "tags"));
        return this;
    }

    public ComputeMetadataBuilder ids(String id) {
        this.id(id).providerId(id);
        return this;
    }

    public ComputeMetadataBuilder providerId(String providerId) {
        return (ComputeMetadataBuilder)ComputeMetadataBuilder.class.cast(super.providerId(providerId));
    }

    public ComputeMetadataBuilder name(String name) {
        return (ComputeMetadataBuilder)ComputeMetadataBuilder.class.cast(super.name(name));
    }

    public ComputeMetadataBuilder location(Location location) {
        return (ComputeMetadataBuilder)ComputeMetadataBuilder.class.cast(super.location(location));
    }

    public ComputeMetadataBuilder uri(URI uri) {
        return (ComputeMetadataBuilder)ComputeMetadataBuilder.class.cast(super.uri(uri));
    }

    public ComputeMetadataBuilder userMetadata(Map<String, String> userMetadata) {
        return (ComputeMetadataBuilder)ComputeMetadataBuilder.class.cast(super.userMetadata(userMetadata));
    }

    public ComputeMetadata build() {
        return new ComputeMetadataImpl(this.type, this.providerId, this.name, this.id, this.location, this.uri, this.userMetadata, this.tags);
    }

    public static ComputeMetadataBuilder fromComputeMetadata(ComputeMetadata in) {
        return ((ComputeMetadataBuilder)new ComputeMetadataBuilder(in.getType()).id(in.getId()).location(in.getLocation()).name(in.getName()).uri(in.getUri()).userMetadata((Map)in.getUserMetadata())).tags(in.getTags());
    }
}

