/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.config;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.predicates.AtomicImageAvailable;
import org.jclouds.compute.predicates.AtomicImageDeleted;
import org.jclouds.compute.predicates.AtomicNodeRunning;
import org.jclouds.compute.predicates.AtomicNodeSuspended;
import org.jclouds.compute.predicates.AtomicNodeTerminated;
import org.jclouds.compute.predicates.ScriptStatusReturnsZero;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.predicates.RetryablePredicate;

public class ComputeServiceTimeoutsModule
extends AbstractModule {
    @Provides
    @Singleton
    @Named(value="jclouds.compute.timeout.node-running")
    protected Predicate<AtomicReference<NodeMetadata>> nodeRunning(AtomicNodeRunning statusRunning, ComputeServiceConstants.Timeouts timeouts, ComputeServiceConstants.PollPeriod period) {
        return timeouts.nodeRunning == 0L ? statusRunning : new RetryablePredicateGuardingNull<NodeMetadata>(statusRunning, timeouts.nodeRunning, period.pollInitialPeriod, period.pollMaxPeriod);
    }

    @Provides
    @Singleton
    @Named(value="jclouds.compute.timeout.node-terminated")
    protected Predicate<AtomicReference<NodeMetadata>> serverTerminated(AtomicNodeTerminated statusTerminated, ComputeServiceConstants.Timeouts timeouts, ComputeServiceConstants.PollPeriod period) {
        return timeouts.nodeTerminated == 0L ? statusTerminated : new RetryablePredicate<AtomicReference<NodeMetadata>>(statusTerminated, timeouts.nodeTerminated, period.pollInitialPeriod, period.pollMaxPeriod);
    }

    @Provides
    @Singleton
    @Named(value="jclouds.compute.timeout.node-suspended")
    protected Predicate<AtomicReference<NodeMetadata>> serverSuspended(AtomicNodeSuspended statusSuspended, ComputeServiceConstants.Timeouts timeouts, ComputeServiceConstants.PollPeriod period) {
        return timeouts.nodeSuspended == 0L ? statusSuspended : new RetryablePredicateGuardingNull<NodeMetadata>(statusSuspended, timeouts.nodeSuspended, period.pollInitialPeriod, period.pollMaxPeriod);
    }

    @Provides
    @Singleton
    @Named(value="jclouds.compute.timeout.script-complete")
    protected Predicate<ScriptStatusReturnsZero.CommandUsingClient> runScriptRunning(ScriptStatusReturnsZero statusRunning, ComputeServiceConstants.Timeouts timeouts) {
        return timeouts.scriptComplete == 0L ? Predicates.not(statusRunning) : new RetryablePredicate<ScriptStatusReturnsZero.CommandUsingClient>(Predicates.not(statusRunning), timeouts.scriptComplete);
    }

    @Provides
    @Singleton
    @Named(value="jclouds.compute.timeout.image-available")
    protected Predicate<AtomicReference<Image>> imageAvailable(AtomicImageAvailable statusAvailable, ComputeServiceConstants.Timeouts timeouts, ComputeServiceConstants.PollPeriod period) {
        return timeouts.imageAvailable == 0L ? statusAvailable : new RetryablePredicateGuardingNull<Image>(statusAvailable, timeouts.imageAvailable, period.pollInitialPeriod, period.pollMaxPeriod);
    }

    @Provides
    @Singleton
    @Named(value="jclouds.compute.timeout.image-deleted")
    protected Predicate<AtomicReference<Image>> serverDeleted(AtomicImageDeleted statusDeleted, ComputeServiceConstants.Timeouts timeouts, ComputeServiceConstants.PollPeriod period) {
        return timeouts.imageDeleted == 0L ? statusDeleted : new RetryablePredicate<AtomicReference<Image>>(statusDeleted, timeouts.imageDeleted, period.pollInitialPeriod, period.pollMaxPeriod);
    }

    @Override
    protected void configure() {
    }

    private static class RetryablePredicateGuardingNull<T>
    implements Predicate<AtomicReference<T>> {
        private final RetryablePredicate<AtomicRefAndOrig> retryablePredicate;

        public RetryablePredicateGuardingNull(final Predicate<AtomicReference<T>> predicate, long maxWait, long period, long maxPeriod) {
            Predicate<AtomicRefAndOrig> nonNullThingPredicate = new Predicate<AtomicRefAndOrig>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean apply(AtomicRefAndOrig input) {
                    AtomicReference<Object> ref = input.ref.get() != null ? input.ref : new AtomicReference<Object>(input.orig);
                    try {
                        boolean bl = predicate.apply(ref);
                        return bl;
                    }
                    finally {
                        input.ref.set(ref.get());
                    }
                }
            };
            this.retryablePredicate = new RetryablePredicate<AtomicRefAndOrig>(nonNullThingPredicate, maxWait, period, maxPeriod);
        }

        @Override
        public boolean apply(AtomicReference<T> input) {
            AtomicRefAndOrig refAndOrig = new AtomicRefAndOrig(input.get(), input);
            return this.retryablePredicate.apply(refAndOrig);
        }

        private class AtomicRefAndOrig {
            private final T orig;
            private final AtomicReference<T> ref;

            AtomicRefAndOrig(T orig, AtomicReference<T> ref) {
                this.orig = orig;
                this.ref = ref;
            }
        }
    }
}

