/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.options;

import com.google.common.collect.ImmutableSet;
import org.jclouds.cloudstack.domain.Volume;
import org.jclouds.cloudstack.options.AccountInDomainOptions;

public class ListVolumesOptions
extends AccountInDomainOptions {
    public static final ListVolumesOptions NONE = new ListVolumesOptions();

    public ListVolumesOptions hostId(String hostId) {
        this.queryParameters.replaceValues("hostid", ImmutableSet.of(hostId + ""));
        return this;
    }

    public ListVolumesOptions id(String id) {
        this.queryParameters.replaceValues("id", ImmutableSet.of(id + ""));
        return this;
    }

    public ListVolumesOptions isRecursive(boolean recursive) {
        this.queryParameters.replaceValues("isrecursive", ImmutableSet.of(String.valueOf(recursive)));
        return this;
    }

    public ListVolumesOptions keyword(String keyword) {
        this.queryParameters.replaceValues("keyword", ImmutableSet.of(keyword));
        return this;
    }

    public ListVolumesOptions name(String name) {
        this.queryParameters.replaceValues("name", ImmutableSet.of(name));
        return this;
    }

    public ListVolumesOptions podId(String podId) {
        this.queryParameters.replaceValues("podid", ImmutableSet.of(podId + ""));
        return this;
    }

    public ListVolumesOptions type(Volume.Type type) {
        this.queryParameters.replaceValues("type", ImmutableSet.of(type.toString()));
        return this;
    }

    public ListVolumesOptions virtualMachineId(String virtualMachineId) {
        this.queryParameters.replaceValues("virtualmachineid", ImmutableSet.of(virtualMachineId + ""));
        return this;
    }

    public ListVolumesOptions zoneId(String zoneId) {
        this.queryParameters.replaceValues("zoneid", ImmutableSet.of(zoneId + ""));
        return this;
    }

    @Override
    public ListVolumesOptions accountInDomain(String account, String domain) {
        return (ListVolumesOptions)ListVolumesOptions.class.cast(super.accountInDomain(account, domain));
    }

    @Override
    public ListVolumesOptions domainId(String domainId) {
        return (ListVolumesOptions)ListVolumesOptions.class.cast(super.domainId(domainId));
    }

    public static class Builder {
        public static ListVolumesOptions accountInDomain(String account, String domain) {
            ListVolumesOptions options = new ListVolumesOptions();
            return options.accountInDomain(account, domain);
        }

        public static ListVolumesOptions domainId(String id) {
            ListVolumesOptions options = new ListVolumesOptions();
            return options.domainId(id);
        }

        public static ListVolumesOptions hostId(String id) {
            ListVolumesOptions options = new ListVolumesOptions();
            return options.hostId(id);
        }

        public static ListVolumesOptions id(String id) {
            ListVolumesOptions options = new ListVolumesOptions();
            return options.id(id);
        }

        public static ListVolumesOptions isRecursive(boolean recursive) {
            ListVolumesOptions options = new ListVolumesOptions();
            return options.isRecursive(recursive);
        }

        public static ListVolumesOptions keyword(String keyword) {
            ListVolumesOptions options = new ListVolumesOptions();
            return options.keyword(keyword);
        }

        public static ListVolumesOptions name(String name) {
            ListVolumesOptions options = new ListVolumesOptions();
            return options.name(name);
        }

        public static ListVolumesOptions podId(String id) {
            ListVolumesOptions options = new ListVolumesOptions();
            return options.podId(id);
        }

        public static ListVolumesOptions type(Volume.Type type) {
            ListVolumesOptions options = new ListVolumesOptions();
            return options.type(type);
        }

        public static ListVolumesOptions virtualMachineId(String virtualMachineId) {
            ListVolumesOptions options = new ListVolumesOptions();
            return options.virtualMachineId(virtualMachineId);
        }

        public static ListVolumesOptions zoneId(String id) {
            ListVolumesOptions options = new ListVolumesOptions();
            return options.zoneId(id);
        }
    }
}

