/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.options;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Map;
import org.jclouds.cloudstack.options.AccountInDomainOptions;
import org.jclouds.encryption.internal.Base64;

public class DeployVirtualMachineOptions
extends AccountInDomainOptions {
    public static final DeployVirtualMachineOptions NONE = new DeployVirtualMachineOptions();

    public DeployVirtualMachineOptions diskOfferingId(String diskofferingid) {
        Preconditions.checkArgument(!this.queryParameters.containsKey("size"), "Mutually exclusive with size");
        this.queryParameters.replaceValues("diskofferingid", ImmutableSet.of(diskofferingid + ""));
        return this;
    }

    public DeployVirtualMachineOptions displayName(String displayName) {
        this.queryParameters.replaceValues("displayname", ImmutableSet.of(displayName));
        return this;
    }

    public DeployVirtualMachineOptions group(String group) {
        this.queryParameters.replaceValues("group", ImmutableSet.of(group));
        return this;
    }

    public DeployVirtualMachineOptions hypervisor(String hypervisor) {
        this.queryParameters.replaceValues("hypervisor", ImmutableSet.of(hypervisor));
        return this;
    }

    public DeployVirtualMachineOptions keyPair(String keyPair) {
        this.queryParameters.replaceValues("keypair", ImmutableSet.of(keyPair));
        return this;
    }

    public DeployVirtualMachineOptions name(String name) {
        this.queryParameters.replaceValues("name", ImmutableSet.of(name));
        return this;
    }

    public DeployVirtualMachineOptions ipOnDefaultNetwork(String ipOnDefaultNetwork) {
        this.queryParameters.replaceValues("ipaddress", ImmutableSet.of(ipOnDefaultNetwork));
        return this;
    }

    public DeployVirtualMachineOptions ipsToNetworks(Map<String, String> ipsToNetworks) {
        int count = 0;
        for (String ip : ipsToNetworks.keySet()) {
            this.queryParameters.replaceValues(String.format("iptonetworklist[%d].ip", count), ImmutableSet.of(ip));
            this.queryParameters.replaceValues(String.format("iptonetworklist[%d].networkid", count), ImmutableSet.of("" + ipsToNetworks.get(ip)));
            ++count;
        }
        return this;
    }

    public DeployVirtualMachineOptions networkId(String networkId) {
        this.queryParameters.replaceValues("networkids", ImmutableSet.of(networkId + ""));
        return this;
    }

    public DeployVirtualMachineOptions networkIds(Iterable<String> networkIds) {
        this.queryParameters.replaceValues("networkids", ImmutableSet.of(Joiner.on(',').join(networkIds)));
        return this;
    }

    public Iterable<String> getNetworkIds() {
        if (this.queryParameters.get("networkids").size() == 1) {
            return Iterables.transform(Splitter.on(",").split((CharSequence)Iterables.getOnlyElement(this.queryParameters.get("networkids"))), new Function<String, String>(){

                @Override
                public String apply(String arg0) {
                    return arg0;
                }
            });
        }
        return ImmutableSet.of();
    }

    public DeployVirtualMachineOptions securityGroupId(String securityGroupId) {
        this.queryParameters.replaceValues("securitygroupids", ImmutableSet.of(securityGroupId + ""));
        return this;
    }

    public DeployVirtualMachineOptions securityGroupIds(Iterable<String> securityGroupIds) {
        this.queryParameters.replaceValues("securitygroupids", ImmutableSet.of(Joiner.on(',').join(securityGroupIds)));
        return this;
    }

    public DeployVirtualMachineOptions dataDiskSize(long dataDiskSize) {
        Preconditions.checkArgument(!this.queryParameters.containsKey("diskofferingid"), "Mutually exclusive with diskOfferingId");
        this.queryParameters.replaceValues("size", ImmutableSet.of(dataDiskSize + ""));
        return this;
    }

    public DeployVirtualMachineOptions userData(byte[] unencodedData) {
        int length = Preconditions.checkNotNull(unencodedData, "unencodedData").length;
        Preconditions.checkArgument(length > 0, "userData cannot be empty");
        Preconditions.checkArgument(length <= 2048, "userData cannot be larger than 2kb");
        this.queryParameters.replaceValues("userdata", ImmutableSet.of(Base64.encodeBytes(unencodedData)));
        return this;
    }

    @Override
    public DeployVirtualMachineOptions accountInDomain(String account, String domain) {
        return (DeployVirtualMachineOptions)DeployVirtualMachineOptions.class.cast(super.accountInDomain(account, domain));
    }

    @Override
    public DeployVirtualMachineOptions domainId(String domainId) {
        return (DeployVirtualMachineOptions)DeployVirtualMachineOptions.class.cast(super.domainId(domainId));
    }

    public static class Builder {
        public static DeployVirtualMachineOptions diskOfferingId(String diskOfferingId) {
            DeployVirtualMachineOptions options = new DeployVirtualMachineOptions();
            return options.diskOfferingId(diskOfferingId);
        }

        public static DeployVirtualMachineOptions displayName(String displayName) {
            DeployVirtualMachineOptions options = new DeployVirtualMachineOptions();
            return options.displayName(displayName);
        }

        public static DeployVirtualMachineOptions group(String group) {
            DeployVirtualMachineOptions options = new DeployVirtualMachineOptions();
            return options.group(group);
        }

        public static DeployVirtualMachineOptions hypervisor(String hypervisor) {
            DeployVirtualMachineOptions options = new DeployVirtualMachineOptions();
            return options.hypervisor(hypervisor);
        }

        public static DeployVirtualMachineOptions keyPair(String keyPair) {
            DeployVirtualMachineOptions options = new DeployVirtualMachineOptions();
            return options.keyPair(keyPair);
        }

        public static DeployVirtualMachineOptions name(String name) {
            DeployVirtualMachineOptions options = new DeployVirtualMachineOptions();
            return options.name(name);
        }

        public static DeployVirtualMachineOptions ipOnDefaultNetwork(String ipOnDefaultNetwork) {
            DeployVirtualMachineOptions options = new DeployVirtualMachineOptions();
            return options.ipOnDefaultNetwork(ipOnDefaultNetwork);
        }

        public static DeployVirtualMachineOptions ipsToNetworks(Map<String, String> ipsToNetworks) {
            DeployVirtualMachineOptions options = new DeployVirtualMachineOptions();
            return options.ipsToNetworks(ipsToNetworks);
        }

        public static DeployVirtualMachineOptions networkId(String id) {
            DeployVirtualMachineOptions options = new DeployVirtualMachineOptions();
            return options.networkId(id);
        }

        public static DeployVirtualMachineOptions networkIds(Iterable<String> networkIds) {
            DeployVirtualMachineOptions options = new DeployVirtualMachineOptions();
            return options.networkIds(networkIds);
        }

        public static DeployVirtualMachineOptions securityGroupId(String id) {
            DeployVirtualMachineOptions options = new DeployVirtualMachineOptions();
            return options.securityGroupId(id);
        }

        public static DeployVirtualMachineOptions securityGroupIds(Iterable<String> securityGroupIds) {
            DeployVirtualMachineOptions options = new DeployVirtualMachineOptions();
            return options.securityGroupIds(securityGroupIds);
        }

        public static DeployVirtualMachineOptions dataDiskSize(long id) {
            DeployVirtualMachineOptions options = new DeployVirtualMachineOptions();
            return options.dataDiskSize(id);
        }

        public static DeployVirtualMachineOptions userData(byte[] unencodedData) {
            DeployVirtualMachineOptions options = new DeployVirtualMachineOptions();
            return options.userData(unencodedData);
        }

        public static DeployVirtualMachineOptions accountInDomain(String account, String domain) {
            DeployVirtualMachineOptions options = new DeployVirtualMachineOptions();
            return options.accountInDomain(account, domain);
        }

        public static DeployVirtualMachineOptions domainId(String domainId) {
            DeployVirtualMachineOptions options = new DeployVirtualMachineOptions();
            return options.domainId(domainId);
        }
    }
}

