/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.util.Date;
import org.jclouds.javax.annotation.Nullable;

public class VMGroup {
    private final String id;
    private final String account;
    private final Date created;
    private final String domain;
    private final String domainId;
    private final String name;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromVMGroup(this);
    }

    @ConstructorProperties(value={"id", "account", "created", "domain", "domainid", "name"})
    protected VMGroup(String id, @Nullable String account, @Nullable Date created, @Nullable String domain, @Nullable String domainId, @Nullable String name) {
        this.id = Preconditions.checkNotNull(id, "id");
        this.account = account;
        this.created = created;
        this.domain = domain;
        this.domainId = domainId;
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public String getAccount() {
        return this.account;
    }

    @Nullable
    public Date getCreated() {
        return this.created;
    }

    @Nullable
    public String getDomain() {
        return this.domain;
    }

    @Nullable
    public String getDomainId() {
        return this.domainId;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return Objects.hashCode(this.id, this.account, this.created, this.domain, this.domainId, this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        VMGroup that = (VMGroup)VMGroup.class.cast(obj);
        return Objects.equal(this.id, that.id) && Objects.equal(this.account, that.account) && Objects.equal(this.created, that.created) && Objects.equal(this.domain, that.domain) && Objects.equal(this.domainId, that.domainId) && Objects.equal(this.name, that.name);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper(this).add("id", this.id).add("account", this.account).add("created", this.created).add("domain", this.domain).add("domainId", this.domainId).add("name", this.name);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected String account;
        protected Date created;
        protected String domain;
        protected String domainId;
        protected String name;

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T account(String account) {
            this.account = account;
            return this.self();
        }

        public T created(Date created) {
            this.created = created;
            return this.self();
        }

        public T domain(String domain) {
            this.domain = domain;
            return this.self();
        }

        public T domainId(String domainId) {
            this.domainId = domainId;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public VMGroup build() {
            return new VMGroup(this.id, this.account, this.created, this.domain, this.domainId, this.name);
        }

        public T fromVMGroup(VMGroup in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).account(in.getAccount())).created(in.getCreated())).domain(in.getDomain())).domainId(in.getDomainId())).name(in.getName());
        }
    }
}

