/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import org.jclouds.cloudsigma.domain.IDEDevice;
import org.jclouds.cloudsigma.domain.Model;
import org.jclouds.cloudsigma.domain.NIC;
import org.jclouds.cloudsigma.domain.Server;
import org.jclouds.cloudsigma.domain.VNC;

public class Servers {
    public static Server.Builder small(String name, String driveUuuid, String vncPassword) {
        return Servers.smallWithStaticIP(name, driveUuuid, vncPassword, "auto");
    }

    public static Server.Builder smallWithStaticIP(String name, String driveUuuid, String vncPassword, String ip) {
        return new Server.Builder().name(name).cpu(1000).mem(512).persistent(true).devices(ImmutableMap.of("ide:0:0", new IDEDevice.Builder(0, 0).uuid(driveUuuid).build())).bootDeviceIds(ImmutableSet.of("ide:0:0")).nics(ImmutableSet.of(new NIC.Builder().model(Model.E1000).dhcp(ip).build())).vnc(new VNC(null, vncPassword, false));
    }

    public static Server changeIP(Server in, String ip) {
        return Server.Builder.fromServer(in).nics(ImmutableSet.of(new NIC.Builder().model(Model.E1000).dhcp(ip).build())).build();
    }
}

