/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.domain.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.List;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.vcloud.domain.GuestCustomizationSection;
import org.jclouds.vcloud.domain.NetworkConnectionSection;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.Status;
import org.jclouds.vcloud.domain.Task;
import org.jclouds.vcloud.domain.Vm;
import org.jclouds.vcloud.domain.internal.ReferenceTypeImpl;
import org.jclouds.vcloud.domain.ovf.VCloudOperatingSystemSection;
import org.jclouds.vcloud.domain.ovf.VCloudVirtualHardwareSection;

public class VmImpl
extends ReferenceTypeImpl
implements Vm {
    @Nullable
    private final Status status;
    private final ReferenceType vApp;
    @Nullable
    private final String description;
    private final List<Task> tasks = Lists.newArrayList();
    @Nullable
    private final VCloudVirtualHardwareSection hardware;
    private final String vAppScopedLocalId;
    private final VCloudOperatingSystemSection os;
    @Nullable
    private final GuestCustomizationSection guestCustomization;
    @Nullable
    private final NetworkConnectionSection networkConnectionSection;

    public VmImpl(String name, String type, URI id, @Nullable Status status, ReferenceType vApp, @Nullable String description, Iterable<Task> tasks, @Nullable VCloudVirtualHardwareSection hardware, @Nullable VCloudOperatingSystemSection os, @Nullable NetworkConnectionSection networkConnectionSection, @Nullable GuestCustomizationSection guestCustomization, @Nullable String vAppScopedLocalId) {
        super(name, type, id);
        this.status = status;
        this.vApp = vApp;
        this.description = description;
        Iterables.addAll(this.tasks, Preconditions.checkNotNull(tasks, "tasks"));
        this.hardware = hardware;
        this.os = os;
        this.networkConnectionSection = networkConnectionSection;
        this.guestCustomization = guestCustomization;
        this.vAppScopedLocalId = vAppScopedLocalId;
    }

    @Override
    @Nullable
    public Status getStatus() {
        return this.status;
    }

    @Override
    public ReferenceType getParent() {
        return this.vApp;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<Task> getTasks() {
        return this.tasks;
    }

    @Override
    public VCloudVirtualHardwareSection getVirtualHardwareSection() {
        return this.hardware;
    }

    @Override
    public VCloudOperatingSystemSection getOperatingSystemSection() {
        return this.os;
    }

    @Override
    public NetworkConnectionSection getNetworkConnectionSection() {
        return this.networkConnectionSection;
    }

    @Override
    public GuestCustomizationSection getGuestCustomizationSection() {
        return this.guestCustomization;
    }

    @Override
    public String getVAppScopedLocalId() {
        return this.vAppScopedLocalId;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.guestCustomization == null ? 0 : this.guestCustomization.hashCode());
        result = 31 * result + (this.hardware == null ? 0 : this.hardware.hashCode());
        result = 31 * result + (this.networkConnectionSection == null ? 0 : this.networkConnectionSection.hashCode());
        result = 31 * result + (this.os == null ? 0 : this.os.hashCode());
        result = 31 * result + (this.vApp == null ? 0 : this.vApp.hashCode());
        result = 31 * result + (this.vAppScopedLocalId == null ? 0 : this.vAppScopedLocalId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VmImpl other = (VmImpl)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.guestCustomization == null ? other.guestCustomization != null : !this.guestCustomization.equals(other.guestCustomization)) {
            return false;
        }
        if (this.hardware == null ? other.hardware != null : !this.hardware.equals(other.hardware)) {
            return false;
        }
        if (this.networkConnectionSection == null ? other.networkConnectionSection != null : !this.networkConnectionSection.equals(other.networkConnectionSection)) {
            return false;
        }
        if (this.os == null ? other.os != null : !this.os.equals(other.os)) {
            return false;
        }
        if (this.vApp == null ? other.vApp != null : !this.vApp.equals(other.vApp)) {
            return false;
        }
        return !(this.vAppScopedLocalId == null ? other.vAppScopedLocalId != null : !this.vAppScopedLocalId.equals(other.vAppScopedLocalId));
    }

    @Override
    public String toString() {
        return "[href=" + this.getHref() + ", name=" + this.getName() + ", type=" + this.getType() + ", description=" + this.description + ", status=" + (Object)((Object)this.status) + ", tasks=" + this.tasks + ", vApp=" + this.vApp + ", hardware=" + this.hardware + ", os=" + this.os + ", network=" + this.networkConnectionSection + ", vAppScopedLocalId=" + this.vAppScopedLocalId + "]";
    }
}

