/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.domain;

import com.google.common.base.Preconditions;

public enum Status {
    ERROR,
    UNRESOLVED,
    RESOLVED,
    DEPLOYED,
    SUSPENDED,
    ON,
    WAITING_FOR_INPUT,
    UNKNOWN,
    UNRECOGNIZED,
    OFF,
    INCONSISTENT,
    MIXED,
    PENDING_DESCRIPTOR,
    COPYING,
    PENDING_CONTENTS,
    QUARANTINED,
    QUARANTINE_EXPIRED,
    REJECTED,
    TRANSFER_TIMEOUT;


    public String value() {
        switch (this) {
            case UNRESOLVED: {
                return "0";
            }
            case RESOLVED: {
                return "1";
            }
            case DEPLOYED: {
                return "2";
            }
            case SUSPENDED: {
                return "3";
            }
            case ON: {
                return "4";
            }
            case WAITING_FOR_INPUT: {
                return "5";
            }
            case UNKNOWN: {
                return "6";
            }
            case UNRECOGNIZED: {
                return "7";
            }
            case OFF: {
                return "8";
            }
            case INCONSISTENT: {
                return "9";
            }
            case MIXED: {
                return "10";
            }
            case PENDING_DESCRIPTOR: {
                return "11";
            }
            case COPYING: {
                return "12";
            }
            case PENDING_CONTENTS: {
                return "13";
            }
            case QUARANTINED: {
                return "14";
            }
            case QUARANTINE_EXPIRED: {
                return "15";
            }
            case REJECTED: {
                return "16";
            }
            case TRANSFER_TIMEOUT: {
                return "17";
            }
        }
        return "7";
    }

    public static Status fromValue(String status) {
        try {
            return Status.fromValue(Integer.parseInt(Preconditions.checkNotNull(status, "status")));
        }
        catch (IllegalArgumentException e) {
            return UNRECOGNIZED;
        }
    }

    public static Status fromValue(int v) {
        switch (v) {
            case 0: {
                return UNRESOLVED;
            }
            case 1: {
                return RESOLVED;
            }
            case 2: {
                return DEPLOYED;
            }
            case 3: {
                return SUSPENDED;
            }
            case 4: {
                return ON;
            }
            case 5: {
                return WAITING_FOR_INPUT;
            }
            case 6: {
                return UNKNOWN;
            }
            case 7: {
                return UNRECOGNIZED;
            }
            case 8: {
                return OFF;
            }
            case 9: {
                return INCONSISTENT;
            }
            case 10: {
                return MIXED;
            }
            case 11: {
                return PENDING_DESCRIPTOR;
            }
            case 12: {
                return COPYING;
            }
            case 13: {
                return PENDING_CONTENTS;
            }
            case 14: {
                return QUARANTINED;
            }
            case 15: {
                return QUARANTINE_EXPIRED;
            }
            case 16: {
                return REJECTED;
            }
            case 17: {
                return TRANSFER_TIMEOUT;
            }
        }
        return UNRECOGNIZED;
    }
}

