/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.slicehost.xml;

import com.google.common.collect.Sets;
import java.util.Set;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.slicehost.domain.Slice;
import org.xml.sax.SAXException;

public class SliceHandler
extends ParseSax.HandlerWithResult<Slice> {
    private StringBuilder currentText = new StringBuilder();
    private int id;
    private String name;
    private int flavorId;
    @Nullable
    private Integer imageId;
    @Nullable
    private Integer backupId;
    private Slice.Status status;
    @Nullable
    private Integer progress;
    private float bandwidthIn;
    private float bandwidthOut;
    private Set<String> addresses = Sets.newLinkedHashSet();
    @Nullable
    private String rootPassword;
    private Slice slice;

    @Override
    public Slice getResult() {
        return this.slice;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("id")) {
            this.id = Integer.parseInt(this.currentText.toString().trim());
        } else if (qName.equalsIgnoreCase("name")) {
            this.name = this.currentText.toString().trim();
        } else if (qName.equalsIgnoreCase("flavor-id")) {
            this.flavorId = Integer.parseInt(this.currentText.toString().trim());
        } else if (qName.equalsIgnoreCase("image-id")) {
            this.imageId = Integer.parseInt(this.currentText.toString().trim());
        } else if (qName.equalsIgnoreCase("backup-id")) {
            this.backupId = Integer.parseInt(this.currentText.toString().trim());
        } else if (qName.equalsIgnoreCase("status")) {
            this.status = Slice.Status.fromValue(this.currentText.toString().trim());
        } else if (qName.equalsIgnoreCase("progress")) {
            try {
                this.progress = Integer.parseInt(this.currentText.toString().trim());
            }
            catch (NumberFormatException e) {}
        } else if (qName.equalsIgnoreCase("bw-in")) {
            this.bandwidthIn = Float.parseFloat(this.currentText.toString().trim());
        } else if (qName.equalsIgnoreCase("bw-out")) {
            this.bandwidthOut = Float.parseFloat(this.currentText.toString().trim());
        } else if (qName.equalsIgnoreCase("address")) {
            this.addresses.add(this.currentText.toString().trim());
        } else if (qName.equalsIgnoreCase("root-password")) {
            this.rootPassword = this.currentText.toString().trim();
        } else if (qName.equalsIgnoreCase("slice")) {
            this.slice = new Slice(this.id, this.name, this.flavorId, this.imageId, this.backupId, this.status, this.progress, this.bandwidthIn, this.bandwidthOut, this.addresses, this.rootPassword);
            this.id = -1;
            this.name = null;
            this.flavorId = -1;
            this.imageId = null;
            this.backupId = null;
            this.status = null;
            this.progress = null;
            this.bandwidthIn = 0.0f;
            this.bandwidthOut = 0.0f;
            this.addresses = Sets.newLinkedHashSet();
            this.rootPassword = null;
        }
        this.currentText = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

