/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.slicehost.domain;

public class Flavor {
    private final int id;
    private final String name;
    private final int price;
    private final int ram;

    public Flavor(int id, String name, int price, int ram) {
        this.id = id;
        this.name = name;
        this.price = price;
        this.ram = ram;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getPrice() {
        return this.price;
    }

    public int getRam() {
        return this.ram;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + Float.floatToIntBits(this.price);
        result = 31 * result + this.ram;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Flavor other = (Flavor)obj;
        if (this.id != other.id) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (Float.floatToIntBits(this.price) != Float.floatToIntBits(other.price)) {
            return false;
        }
        return this.ram == other.ram;
    }

    public String toString() {
        return "[id=" + this.id + ", name=" + this.name + ", price=" + this.price + ", ram=" + this.ram + "]";
    }
}

