/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.route53.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import org.jclouds.route53.domain.Zone;

public final class ZoneAndNameServers {
    private final Zone zone;
    private final ImmutableList<String> nameServers;

    private ZoneAndNameServers(Zone zone, ImmutableList<String> nameServers) {
        this.zone = Preconditions.checkNotNull(zone, "zone");
        this.nameServers = Preconditions.checkNotNull(nameServers, "nameServers for %s", zone);
    }

    public Zone getZone() {
        return this.zone;
    }

    public ImmutableList<String> getNameServers() {
        return this.nameServers;
    }

    public int hashCode() {
        return Objects.hashCode(this.zone, this.nameServers);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ZoneAndNameServers that = (ZoneAndNameServers)ZoneAndNameServers.class.cast(obj);
        return Objects.equal(this.zone, that.zone) && Objects.equal(this.nameServers, that.nameServers);
    }

    public String toString() {
        return Objects.toStringHelper("").add("zone", this.zone).add("nameServers", this.nameServers).toString();
    }

    public static ZoneAndNameServers create(Zone zone, Iterable<String> nameServers) {
        return new ZoneAndNameServers(zone, ImmutableList.copyOf(Preconditions.checkNotNull(nameServers, "nameServers")));
    }
}

