/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.route53.domain;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;

public class RecordSet {
    protected final String name;
    protected final Type type;
    protected final Optional<Integer> ttl;
    protected final Set<String> values;
    protected final Optional<AliasTarget> aliasTarget;

    private RecordSet(String name, Type type, Optional<Integer> ttl, Set<String> values, Optional<AliasTarget> aliasTarget) {
        this.name = Preconditions.checkNotNull(name, "name");
        this.type = Preconditions.checkNotNull(type, "type of %s", name);
        this.ttl = Preconditions.checkNotNull(ttl, "ttl for %s", name);
        this.values = Preconditions.checkNotNull(values, "values for %s", name);
        this.aliasTarget = Preconditions.checkNotNull(aliasTarget, "aliasTarget for %s", aliasTarget);
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public Optional<Integer> getTTL() {
        return this.ttl;
    }

    public Set<String> getValues() {
        return this.values;
    }

    public Optional<AliasTarget> getAliasTarget() {
        return this.aliasTarget;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.name, this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RecordSet other = (RecordSet)RecordSet.class.cast(obj);
        return Objects.equal(this.name, other.name) && Objects.equal((Object)this.type, (Object)other.type);
    }

    public String toString() {
        return Objects.toStringHelper("").omitNullValues().add("name", this.name).add("type", (Object)this.type).add("ttl", this.ttl.orNull()).add("values", this.values.isEmpty() ? null : this.values).add("aliasTarget", this.aliasTarget.orNull()).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return RecordSet.builder().from(this);
    }

    public static final class Builder {
        private String id;
        private String name;
        private Type type;
        private Optional<Integer> ttl = Optional.absent();
        private ImmutableSet.Builder<String> values = ImmutableSet.builder();
        private String dnsName;
        private String zoneId;
        private Integer weight;
        private String region;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public Builder ttl(Integer ttl) {
            this.ttl = Optional.fromNullable(ttl);
            return this;
        }

        public Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public Builder zoneId(String zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public Builder aliasTarget(AliasTarget aliasTarget) {
            if (aliasTarget == null) {
                this.dnsName = null;
                this.zoneId = null;
            } else {
                this.dnsName = aliasTarget.dnsName;
                this.zoneId = aliasTarget.zoneId;
            }
            return this;
        }

        public Builder add(String values) {
            this.values.add((Object)values);
            return this;
        }

        public Builder addAll(Iterable<String> values) {
            this.values.addAll((Iterable)values);
            return this;
        }

        public Builder weight(Integer weight) {
            this.weight = weight;
            return this;
        }

        public Builder region(String region) {
            this.region = region;
            return this;
        }

        public RecordSet build() {
            Optional aliasTarget;
            Optional<Object> optional = aliasTarget = this.dnsName != null ? Optional.fromNullable(AliasTarget.dnsNameInZone(this.dnsName, this.zoneId)) : Optional.absent();
            if (this.weight != null) {
                return new RecordSubset.Weighted(this.id, this.name, this.type, this.weight, this.ttl, (Set)((Object)this.values.build()), aliasTarget);
            }
            if (this.region != null) {
                return new RecordSubset.Latency(this.id, this.name, this.type, this.region, this.ttl, (Set)((Object)this.values.build()), aliasTarget);
            }
            return new RecordSet(this.name, this.type, this.ttl, (Set)((Object)this.values.build()), aliasTarget);
        }

        public Builder from(RecordSet in) {
            if (in instanceof RecordSubset) {
                this.id(((RecordSubset)RecordSubset.class.cast(in)).id);
            }
            if (in instanceof RecordSubset.Weighted) {
                this.weight(((RecordSubset.Weighted)RecordSubset.Weighted.class.cast(in)).weight);
            } else if (in instanceof RecordSubset.Latency) {
                this.region(((RecordSubset.Latency)RecordSubset.Latency.class.cast(in)).region);
            }
            return this.name(in.name).type(in.type).ttl(in.ttl.orNull()).addAll(in.values).aliasTarget(in.aliasTarget.orNull());
        }
    }

    public static abstract class RecordSubset
    extends RecordSet {
        private final String id;

        private RecordSubset(String id, String name, Type type, Optional<Integer> ttl, Set<String> values, Optional<AliasTarget> aliasTarget) {
            super(name, type, ttl, values, aliasTarget);
            this.id = Preconditions.checkNotNull(id, "id of %s", name);
        }

        public String getId() {
            return this.id;
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(super.hashCode(), this.id);
        }

        @Override
        public boolean equals(Object obj) {
            if (super.equals(obj) && obj instanceof RecordSubset) {
                RecordSubset that = (RecordSubset)RecordSubset.class.cast(obj);
                return Objects.equal(this.id, that.id);
            }
            return false;
        }

        abstract Objects.ToStringHelper differentiate(Objects.ToStringHelper var1);

        @Override
        public String toString() {
            return this.differentiate(Objects.toStringHelper("").omitNullValues().add("id", this.id).add("name", this.name).add("type", (Object)this.type)).add("ttl", this.ttl.orNull()).add("values", this.values.isEmpty() ? null : this.values).add("aliasTarget", this.aliasTarget.orNull()).toString();
        }

        public static final class Latency
        extends RecordSubset {
            private final String region;

            private Latency(String id, String name, Type type, String region, Optional<Integer> ttl, Set<String> values, Optional<AliasTarget> aliasTarget) {
                super(id, name, type, ttl, values, aliasTarget);
                this.region = Preconditions.checkNotNull(region, "region of %s", name);
            }

            public String getRegion() {
                return this.region;
            }

            @Override
            Objects.ToStringHelper differentiate(Objects.ToStringHelper in) {
                return in.add("region", this.region);
            }
        }

        public static final class Weighted
        extends RecordSubset {
            private final int weight;

            private Weighted(String id, String name, Type type, int weight, Optional<Integer> ttl, Set<String> values, Optional<AliasTarget> aliasTarget) {
                super(id, name, type, ttl, values, aliasTarget);
                this.weight = weight;
            }

            public int getWeight() {
                return this.weight;
            }

            @Override
            Objects.ToStringHelper differentiate(Objects.ToStringHelper in) {
                return in.add("weight", this.weight);
            }
        }
    }

    public static class AliasTarget {
        private final String dnsName;
        private final String zoneId;

        public static AliasTarget dnsNameInZone(String dnsName, String zoneId) {
            return new AliasTarget(dnsName, zoneId);
        }

        private AliasTarget(String dnsName, String zoneId) {
            this.dnsName = Preconditions.checkNotNull(dnsName, "dnsName");
            this.zoneId = Preconditions.checkNotNull(zoneId, "zoneId of %s", dnsName);
        }

        public String getDNSName() {
            return this.dnsName;
        }

        public String getZoneId() {
            return this.zoneId;
        }

        public int hashCode() {
            return Objects.hashCode(this.zoneId, this.dnsName);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            AliasTarget other = (AliasTarget)AliasTarget.class.cast(obj);
            return Objects.equal(this.dnsName, other.dnsName) && Objects.equal(this.zoneId, other.zoneId);
        }

        public String toString() {
            return Objects.toStringHelper("").omitNullValues().add("dnsName", this.dnsName).add("zoneId", this.zoneId).toString();
        }
    }

    public static enum Type {
        A,
        AAAA,
        CNAME,
        MX,
        NS,
        PTR,
        SOA,
        SPF,
        SRV,
        TXT;

    }
}

