/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rimuhosting.miro.location;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.location.Iso3166;
import org.jclouds.location.Provider;
import org.jclouds.location.suppliers.LocationsSupplier;
import org.jclouds.location.suppliers.all.JustProvider;
import org.jclouds.rimuhosting.miro.RimuHostingClient;
import org.jclouds.rimuhosting.miro.domain.DataCenter;
import org.jclouds.rimuhosting.miro.domain.PricingPlan;

@Singleton
public class RimuHostingLocationSupplier
extends JustProvider
implements LocationsSupplier {
    private final RimuHostingClient sync;
    private final Supplier<Map<String, Supplier<Set<String>>>> isoCodesByIdSupplier;

    @Inject
    RimuHostingLocationSupplier(@Iso3166 Set<String> isoCodes, @Provider String providerName, @Provider Supplier<URI> endpoint, RimuHostingClient sync, @Iso3166 Supplier<Map<String, Supplier<Set<String>>>> isoCodesByIdSupplier) {
        super(providerName, endpoint, isoCodes);
        this.sync = Preconditions.checkNotNull(sync, "sync");
        this.isoCodesByIdSupplier = Preconditions.checkNotNull(isoCodesByIdSupplier, "isoCodesByIdSupplier");
    }

    @Override
    public Set<? extends Location> get() {
        ImmutableSet.Builder locations = ImmutableSet.builder();
        Iterable<DataCenter> list = Iterables.filter(Iterables.transform(this.sync.getPricingPlanList(), new Function<PricingPlan, DataCenter>(){

            @Override
            public DataCenter apply(PricingPlan arg0) {
                return arg0.getDataCenter();
            }
        }), Predicates.notNull());
        Location provider = (Location)Iterables.getOnlyElement(super.get());
        if (Iterables.size(list) == 0) {
            locations.add(provider);
        } else {
            Map<String, Supplier<Set<String>>> isoCodesById = this.isoCodesByIdSupplier.get();
            for (DataCenter from : list) {
                LocationBuilder builder = new LocationBuilder().scope(LocationScope.ZONE).id(from.getId()).description(from.getName()).parent(provider);
                if (isoCodesById.containsKey(from.getId())) {
                    builder.iso3166Codes((Iterable<String>)isoCodesById.get(from.getId()).get());
                }
                locations.add(builder.build());
            }
        }
        return locations.build();
    }
}

