/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rimuhosting.miro.functions;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.http.HttpResponseException;
import org.jclouds.json.Json;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rimuhosting.miro.domain.internal.RimuHostingResponse;

@Singleton
public class ParseRimuHostingException
implements Function<Exception, Object> {
    private Json json;

    @Inject
    public ParseRimuHostingException(Json json) {
        this.json = json;
    }

    @Override
    public Object apply(Exception e) {
        HttpResponseException responseException;
        if (e instanceof HttpResponseException && (responseException = (HttpResponseException)e).getContent() != null) {
            Type setType = new TypeToken<Map<String, RimuHostingResponse>>(){}.getType();
            String test = responseException.getContent();
            Map responseMap = (Map)this.json.fromJson(test, setType);
            RimuHostingResponse firstResponse = (RimuHostingResponse)Iterables.get(responseMap.values(), 0);
            String errorClass = firstResponse.getErrorInfo().getErrorClass();
            if (errorClass.equals("PermissionException")) {
                throw new AuthorizationException(firstResponse.getErrorInfo().getErrorMessage(), responseException);
            }
            throw new RuntimeException(firstResponse.getErrorInfo().getErrorMessage(), e);
        }
        throw Throwables.propagate(e);
    }
}

