/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ovf.xml;

import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import org.jclouds.ovf.OperatingSystemSection;
import org.jclouds.ovf.xml.SectionHandler;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class OperatingSystemSectionHandler
extends SectionHandler<OperatingSystemSection, OperatingSystemSection.Builder> {
    @Inject
    public OperatingSystemSectionHandler(Provider<OperatingSystemSection.Builder> builderProvider) {
        super(builderProvider);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) {
        Map<String, String> attributes = SaxUtils.cleanseAttributes(attrs);
        if (SaxUtils.equalsOrSuffix(qName, "OperatingSystemSection") && attributes.containsKey("id")) {
            ((OperatingSystemSection.Builder)this.builder).id(Integer.parseInt(attributes.get("id")));
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (SaxUtils.equalsOrSuffix(qName, "Info")) {
            ((OperatingSystemSection.Builder)this.builder).info(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "Description")) {
            ((OperatingSystemSection.Builder)this.builder).description(SaxUtils.currentOrNull(this.currentText));
        }
        super.endElement(uri, localName, qName);
    }
}

