/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.net.URI;
import org.jclouds.openstack.domain.Link;

public class LinkPredicates {
    public static Predicate<Link> relationEquals(final Link.Relation rel) {
        Preconditions.checkNotNull(rel, "rel must be defined");
        return new Predicate<Link>(){

            @Override
            public boolean apply(Link link) {
                return rel.equals((Object)link.getRelation());
            }

            public String toString() {
                return "relEquals(" + (Object)((Object)rel) + ")";
            }
        };
    }

    public static Predicate<Link> hrefEquals(final URI href) {
        Preconditions.checkNotNull(href, "href must be defined");
        return new Predicate<Link>(){

            @Override
            public boolean apply(Link link) {
                return href.equals(link.getHref());
            }

            public String toString() {
                return "hrefEquals(" + href + ")";
            }
        };
    }

    public static Predicate<Link> typeEquals(final String type) {
        Preconditions.checkNotNull(type, "type must be defined");
        return new Predicate<Link>(){

            @Override
            public boolean apply(Link link) {
                return type.equals(link.getType());
            }

            public String toString() {
                return "typeEquals(" + type + ")";
            }
        };
    }
}

